/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.projectile;

import gaia.registry.GaiaRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class BombProjectile
extends ThrowableItemProjectile {
    public BombProjectile(EntityType<? extends BombProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BombProjectile(Level level, LivingEntity livingEntity) {
        super(GaiaRegistry.BOMB.get(), livingEntity, level);
    }

    public BombProjectile(Level level, double accelX, double accelY, double accelZ) {
        super(GaiaRegistry.BOMB.get(), accelX, accelY, accelZ, level);
    }

    public Item getDefaultItem() {
        return (Item)GaiaRegistry.PROJECTILE_WEB.get();
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        Entity entity = hitResult.getEntity();
        if (entity != null) {
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)entity2;
                entity.hurt(this.damageSources().magic(), (float)(shooter.getAttribute(Attributes.ATTACK_DAMAGE).getValue() / 2.0));
            }
            entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 2.0f);
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.5f, Level.ExplosionInteraction.NONE);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }
}

