/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.goal;

import gaia.entity.Creep;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class CreepSwellGoal
extends Goal {
    private final Creep creep;
    @Nullable
    private LivingEntity target;

    public CreepSwellGoal(Creep creep) {
        this.creep = creep;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.creep.getTarget();
        return this.creep.getSwellDir() > 0 || livingentity != null && this.creep.distanceToSqr((Entity)livingentity) < 9.0;
    }

    public void start() {
        this.creep.getNavigation().stop();
        this.target = this.creep.getTarget();
    }

    public void stop() {
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.target == null) {
            this.creep.setSwellDir(-1);
        } else if (this.creep.distanceToSqr((Entity)this.target) > 49.0) {
            this.creep.setSwellDir(-1);
        } else if (!this.creep.getSensing().hasLineOfSight((Entity)this.target)) {
            this.creep.setSwellDir(-1);
        } else {
            this.creep.setSwellDir(1);
        }
    }
}

