/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.ItemAbilities;

public class Spriggan
extends AbstractGaiaEntity {
    private byte inWaterTimer;

    public Spriggan(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 20;
        this.inWaterTimer = 0;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MobAttackGoal((PathfinderMob)this, 1.275, true));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.275).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean hurt(DamageSource source, float damage) {
        Player player;
        ItemStack itemstack;
        float input = this.getBaseDamage(source, damage);
        Entity entity = source.getEntity();
        if (entity instanceof Player && (itemstack = (player = (Player)entity).getItemInHand(player.getUsedItemHand())).canPerformAction(ItemAbilities.AXE_DIG)) {
            input *= 1.5f;
        }
        return super.hurt(source, input);
    }

    @Override
    public void aiStep() {
        if (!((Boolean)GaiaConfig.COMMON.disableInvisibility.get()).booleanValue()) {
            if (this.playerDetection(6, TargetingConditions.forCombat())) {
                if (this.hasEffect(MobEffects.INVISIBILITY)) {
                    this.removeEffect(MobEffects.INVISIBILITY);
                }
            } else if (!this.hasEffect(MobEffects.INVISIBILITY) || this.getEffect(MobEffects.INVISIBILITY).getDuration() < 5) {
                this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 20, 0));
            }
        }
        if (!this.level().isClientSide && this.isInWaterOrRain()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)8);
                this.heal(this.getMaxHealth() * 0.1f);
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.isOnFire()) {
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 0));
            this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0));
        }
        super.aiStep();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.SPRIGGAN.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.SPRIGGAN.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.SPRIGGAN.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public static boolean checkSprigganSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Spriggan.checkDaysPassed(levelAccessor) && Spriggan.checkAboveSeaLevel(levelAccessor, pos) && Spriggan.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

