/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.EnchantUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Sharko
extends AbstractGaiaEntity {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.defineId(Sharko.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    private int buffEffect;
    private boolean animationPlay;
    private int animationTimer;
    private byte inWaterTimer;

    public Sharko(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new SharkoMoveControl(this);
        this.xpReward = 20;
        this.setPathfindingMalus(PathType.WATER, 8.0f);
        this.buffEffect = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.275).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION_STATE, (Object)0);
    }

    public int getAnimationState() {
        return (Integer)this.entityData.get(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.entityData.set(ANIMATION_STATE, (Object)state);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectTime * 20, 0));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, effectTime * 20, 2));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide) {
            if (this.isPassenger()) {
                this.stopRiding();
            }
            if (this.isInWater()) {
                if (this.inWaterTimer <= 100) {
                    this.inWaterTimer = (byte)(this.inWaterTimer + 1);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)8);
                    this.heal(this.getMaxHealth() * 0.1f);
                    this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0));
                    this.inWaterTimer = 0;
                }
            }
        }
        if (this.getHealth() <= this.getMaxHealth() * 0.25f && this.getHealth() > 0.0f && this.buffEffect == 0) {
            this.setGoals(1);
            this.setAnimationState(1);
            this.buffEffect = 1;
            this.animationPlay = true;
        }
        if (this.getHealth() > this.getMaxHealth() * 0.25f && this.buffEffect == 1) {
            this.buffEffect = 0;
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 15) {
                ++this.animationTimer;
            } else {
                this.setBuff();
                this.setGoals(0);
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.aiStep();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
        } else {
            this.goalSelector.addGoal(1, (Goal)this.mobAttackGoal);
        }
    }

    private void setBuff() {
        this.level().broadcastEntityEvent((Entity)this, (byte)7);
        this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 0));
    }

    boolean wantsToSwim() {
        LivingEntity livingentity = this.getTarget();
        return livingentity != null && livingentity.isInWater();
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigation;
                this.setSwimming(false);
            }
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        ItemStack bootsSwimming = new ItemStack((ItemLike)Items.LEATHER_BOOTS);
        this.setItemSlot(EquipmentSlot.FEET, bootsSwimming);
    }

    protected void populateDefaultEquipmentEnchantments(ServerLevelAccessor levelAccessor, RandomSource random, DifficultyInstance instance) {
        super.populateDefaultEquipmentEnchantments(levelAccessor, random, instance);
        this.getItemBySlot(EquipmentSlot.FEET).enchant(EnchantUtil.getEnchantmentHolder((Entity)this, (ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER), 2);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.setGoals(0);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentEnchantments(levelAccessor, this.random, difficultyInstance);
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("AnimationState", this.getAnimationState());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("AnimationState")) {
            this.setAnimationState(tag.getInt("AnimationState"));
        }
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.SHARKO.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.SHARKO.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.SHARKO.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected int getFireImmuneTicks() {
        return 10;
    }

    public boolean checkSpawnObstruction(LevelReader reader) {
        return reader.isUnobstructed((Entity)this);
    }

    public static boolean checkSharkoSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean daysPassed = Sharko.checkDaysPassed(levelAccessor);
        boolean isNight = !Sharko.checkDaytime(levelAccessor);
        boolean inWater = Sharko.checkInWater((LevelAccessor)levelAccessor, pos, 20);
        boolean darkEnough = Sharko.isDarkEnoughToSpawn((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)random);
        boolean notPeaceful = Sharko.checkNotPeaceful((LevelAccessor)levelAccessor);
        boolean matchRandom = random.nextInt(30) == 0;
        return daysPassed && isNight && inWater && darkEnough && notPeaceful & matchRandom;
    }

    static class SharkoMoveControl
    extends MoveControl {
        private final Sharko sharko;

        public SharkoMoveControl(Sharko mermaid) {
            super((Mob)mermaid);
            this.sharko = mermaid;
        }

        public void tick() {
            LivingEntity livingentity = this.sharko.getTarget();
            if (this.sharko.wantsToSwim() && this.sharko.isInWater()) {
                if (livingentity != null && livingentity.getY() > this.sharko.getY()) {
                    this.sharko.setDeltaMovement(this.sharko.getDeltaMovement().add(0.0, 0.002, 0.0));
                }
                if (this.operation != MoveControl.Operation.MOVE_TO || this.sharko.getNavigation().isDone()) {
                    this.sharko.setSpeed(0.0f);
                    return;
                }
                double d0 = this.wantedX - this.sharko.getX();
                double d1 = this.wantedY - this.sharko.getY();
                double d2 = this.wantedZ - this.sharko.getZ();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.sharko.setYRot(this.rotlerp(this.sharko.getYRot(), f, 90.0f));
                this.sharko.yBodyRot = this.sharko.getYRot();
                float f1 = (float)(this.speedModifier * this.sharko.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float f2 = Mth.lerp((float)0.125f, (float)this.sharko.getSpeed(), (float)f1);
                this.sharko.setSpeed(f2);
                this.sharko.setDeltaMovement(this.sharko.getDeltaMovement().add((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.sharko.onGround()) {
                    this.sharko.setDeltaMovement(this.sharko.getDeltaMovement().add(0.0, -0.008, 0.0));
                }
                super.tick();
            }
        }
    }
}

