/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.Dwarf;
import gaia.entity.goal.MobAttackGoal;
import gaia.item.weapon.MagicStaffItem;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public class Orc
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.defineId(Orc.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 60, 15.0f);
    private final MobAttackGoal collideAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = difficulty -> difficulty == Difficulty.HARD;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private int buffEffect = 0;
    private boolean animationPlay = false;
    private int animationTimer = 0;
    private int switchHealth = 0;

    public Orc(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Dwarf.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 26.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION_STATE, (Object)0);
    }

    public int getAnimationState() {
        return (Integer)this.entityData.get(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.entityData.set(ANIMATION_STATE, (Object)state);
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (!this.getOffhandItem().isEmpty() && this.getOffhandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            return !(source.getDirectEntity() instanceof AbstractArrow) && super.hurt(source, input);
        }
        return super.hurt(source, input);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            RangedUtil.magic(target, (LivingEntity)this, distanceFactor);
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    @Override
    public void aiStep() {
        if (this.getVariant() == 0) {
            if (this.getHealth() <= this.getMaxHealth() * 0.25f && this.getHealth() > 0.0f && this.buffEffect == 0) {
                this.setGoals(2);
                this.setAnimationState(2);
                this.buffEffect = 1;
                this.animationPlay = true;
            }
            if (this.getHealth() > this.getMaxHealth() * 0.25f && this.buffEffect == 1) {
                this.buffEffect = 0;
                this.animationPlay = false;
                this.animationTimer = 0;
            }
            if (this.animationPlay) {
                if (this.animationTimer != 15) {
                    ++this.animationTimer;
                } else {
                    this.setBuff();
                    this.setGoals(1);
                    this.setAnimationState(0);
                    this.animationPlay = false;
                }
            }
        } else if (this.getVariant() == 1) {
            this.beaconMonster(6, entity -> {
                if (entity instanceof Orc) {
                    entity.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 300, 1, true, true));
                }
            });
            if (this.getHealth() < this.getMaxHealth() * 0.5f && this.switchHealth == 0) {
                this.setGoals(1);
                this.switchHealth = 1;
            }
            if (this.getHealth() > this.getMaxHealth() * 0.5f && this.switchHealth == 1) {
                this.setGoals(0);
                this.switchHealth = 0;
            }
            if (this.animationPlay) {
                if (this.animationTimer != 30) {
                    ++this.animationTimer;
                } else {
                    this.setAnimationState(0);
                    this.animationPlay = false;
                }
            }
        }
        super.aiStep();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.breakDoorGoal);
            this.goalSelector.addGoal(2, (Goal)this.collideAttackGoal);
        } else if (id == 2) {
            this.goalSelector.removeGoal((Goal)this.breakDoorGoal);
            this.goalSelector.removeGoal((Goal)this.collideAttackGoal);
        } else {
            this.goalSelector.removeGoal((Goal)this.breakDoorGoal);
            this.goalSelector.removeGoal((Goal)this.collideAttackGoal);
            this.goalSelector.addGoal(2, (Goal)this.rangedAttackGoal);
            this.setAnimationState(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    private void setBuff() {
        this.level().broadcastEntityEvent((Entity)this, (byte)7);
        this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 0));
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack stack) {
        super.setItemSlot(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.goalSelector.removeGoal((Goal)this.collideAttackGoal);
        this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
        if (this.getMainHandItem().getItem() instanceof MagicStaffItem) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        block0 : switch (this.getVariant()) {
            case 0: {
                switch (random.nextInt(2)) {
                    case 0: {
                        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_AXE));
                        break;
                    }
                    case 1: {
                        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_AXE));
                    }
                }
                break;
            }
            case 1: {
                switch (random.nextInt(2)) {
                    case 0: {
                        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_AXE));
                        break block0;
                    }
                    case 1: {
                        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_AXE));
                    }
                }
            }
        }
        ItemStack itemstack = this.getMainHandItem();
        ItemStack shield = ItemStack.EMPTY;
        ItemStack armor_leggings = ItemStack.EMPTY;
        ItemStack armor_chestplate = ItemStack.EMPTY;
        switch (this.getVariant()) {
            case 0: {
                if (itemstack.getItem() == Items.STONE_AXE) {
                    armor_leggings = new ItemStack((ItemLike)Items.LEATHER_LEGGINGS);
                }
                if (itemstack.getItem() != Items.IRON_AXE) break;
                armor_leggings = new ItemStack((ItemLike)Items.LEATHER_LEGGINGS);
                armor_chestplate = new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE);
                break;
            }
            case 1: {
                if (itemstack.getItem() == Items.WOODEN_AXE) {
                    shield = new ItemStack((ItemLike)GaiaRegistry.STONE_SHIELD.get());
                    armor_leggings = new ItemStack((ItemLike)Items.LEATHER_LEGGINGS);
                    armor_chestplate = new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE);
                }
                if (itemstack.getItem() != Items.STONE_AXE) break;
                shield = new ItemStack((ItemLike)GaiaRegistry.IRON_SHIELD.get());
                armor_leggings = new ItemStack((ItemLike)Items.LEATHER_LEGGINGS);
                armor_chestplate = new ItemStack((ItemLike)Items.IRON_CHESTPLATE);
            }
        }
        this.setItemSlot(EquipmentSlot.OFFHAND, shield);
        this.setItemSlot(EquipmentSlot.LEGS, armor_leggings);
        this.setItemSlot(EquipmentSlot.CHEST, armor_chestplate);
        this.setCanBreakDoors(true);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        if (this.random.nextInt(4) == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.MAGIC_STAFF.get()));
            this.setVariant(2);
        } else {
            switch (this.random.nextInt(2)) {
                case 0: {
                    this.setVariant(0);
                    break;
                }
                case 1: {
                    this.setVariant(1);
                }
            }
        }
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    public void setCanBreakDoors(boolean enabled) {
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(enabled);
        if (enabled) {
            this.goalSelector.addGoal(1, (Goal)this.breakDoorGoal);
        } else {
            this.goalSelector.removeGoal((Goal)this.breakDoorGoal);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public boolean canAttackType(EntityType<?> type) {
        return super.canAttackType(type) && type != GaiaRegistry.ORC.getEntityType();
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.ORC.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.ORC.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.ORC.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkOrcSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Orc.checkDaysPassed(levelAccessor) && Orc.checkAboveSeaLevel(levelAccessor, pos) && Orc.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

