/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.Sporeling;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.SharedEntityData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public class Matango
extends AbstractGaiaEntity
implements IDayMob {
    private static final ResourceLocation KNOCKBACK_ID = ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"matango_knockback_modifier");
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(KNOCKBACK_ID, 1.0, AttributeModifier.Operation.ADD_VALUE);
    private int spawnLimit = 0;
    private int spawnTime = 0;
    private boolean canSpawn = true;

    public Matango(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MobAttackGoal((PathfinderMob)this, 1.25, true));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean hurt(DamageSource source, float damage) {
        Player player;
        ItemStack itemstack;
        float input = this.getBaseDamage(source, damage);
        Entity entity = source.getEntity();
        if (entity instanceof Player && (itemstack = (player = (Player)entity).getItemInHand(player.getUsedItemHand())).canPerformAction(ItemAbilities.AXE_DIG)) {
            input *= 1.5f;
        }
        return super.hurt(source, input);
    }

    @Override
    public void aiStep() {
        this.beaconMonster(2, entity -> {
            if (entity instanceof Sporeling) {
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300, 1, true, true));
            }
        });
        if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)(this.getY() - (double)0.2f));
            int k = Mth.floor((double)this.getZ());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.level().getBlockState(pos);
            if (!blockstate.isAir()) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate).setPos(pos), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + 0.1, this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 4.0 * ((double)this.random.nextFloat() - 0.5), 0.5, ((double)this.random.nextFloat() - 0.5) * 4.0);
            }
        }
        if (this.getHealth() < this.getMaxHealth() * 0.9f && this.getHealth() > this.getMaxHealth() * 0.1f && this.canSpawn) {
            if (this.spawnLimit < 5) {
                if (this.spawnTime >= 0 && this.spawnTime <= 140) {
                    ++this.spawnTime;
                } else {
                    this.setSpawn(0);
                    this.heal(this.getMaxHealth() * 0.2f);
                    ++this.spawnLimit;
                    this.spawnTime = 0;
                }
            } else {
                this.canSpawn = false;
            }
        }
        if (this.isOnFire()) {
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 0));
            this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0));
        }
        super.aiStep();
    }

    private void setSpawn(int id) {
        if (!this.level().isClientSide) {
            Entity entity;
            BlockPos blockpos = this.blockPosition().offset(-1 + this.random.nextInt(3), 1, -1 + this.random.nextInt(3));
            if (id == 0 && (entity = GaiaRegistry.SPORELING.getEntityType().create(this.level())) instanceof Sporeling) {
                Sporeling summon = (Sporeling)entity;
                summon.moveTo(blockpos, 0.0f, 0.0f);
                summon.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(blockpos), MobSpawnType.MOB_SUMMONED, null);
                this.level().addFreshEntity((Entity)summon);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
            this.level().broadcastEntityEvent((Entity)this, (byte)12);
        }
    }

    public void die(DamageSource source) {
        this.spawnLingeringCloud(List.of(new MobEffectInstance(MobEffects.CONFUSION, 200, 0)));
        super.die(source);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        AttributeInstance attributeinstance = this.getAttribute(Attributes.ATTACK_KNOCKBACK);
        attributeinstance.removeModifier(KNOCKBACK_ID);
        attributeinstance.addTransientModifier(KNOCKBACK_MODIFIER);
        return data;
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return effectInstance.getEffect() != MobEffects.POISON && super.canBeAffected(effectInstance);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.MATANGO.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.MATANGO.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.MATANGO.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkMatangoSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Matango.checkDaysPassed(levelAccessor) && Matango.checkDaytime(levelAccessor) && Matango.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Matango.checkAboveSeaLevel(levelAccessor, pos) && Matango.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

