/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public class Goblin
extends AbstractAssistGaiaEntity
implements RangedAttackMob,
IDayMob {
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 60, 15.0f);
    private final MobAttackGoal collideAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);

    public Goblin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.targetSelector.addGoal(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 26.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (!this.getOffhandItem().isEmpty() && this.getOffhandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            return !(source.getDirectEntity() instanceof AbstractArrow) && super.hurt(source, input);
        }
        return super.hurt(source, input);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            RangedUtil.bomb(target, (LivingEntity)this, distanceFactor);
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack stack) {
        super.setItemSlot(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.goalSelector.removeGoal((Goal)this.collideAttackGoal);
        this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
        if (this.getMainHandItem().is((Item)GaiaRegistry.PROJECTILE_BOMB.get())) {
            this.goalSelector.addGoal(1, (Goal)this.rangedAttackGoal);
        } else {
            this.goalSelector.addGoal(1, (Goal)this.collideAttackGoal);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        if (random.nextInt(4) == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.PROJECTILE_BOMB.get()));
            this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.FLINT_AND_STEEL));
            this.setVariant(1);
        } else {
            if (random.nextInt(4) == 0) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_AXE));
            }
            this.setVariant(0);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCombatTask();
    }

    @Override
    public boolean canAttackType(EntityType<?> type) {
        return super.canAttackType(type) && type != GaiaRegistry.GOBLIN.getEntityType();
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.GOBLIN.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.GOBLIN.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.GOBLIN.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkGoblinSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Goblin.checkDaysPassed(levelAccessor) && Goblin.checkDaytime(levelAccessor) && Goblin.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Goblin.checkAboveSeaLevel(levelAccessor, pos) && Goblin.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

