/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.goal.StrafeGoal;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Deathword
extends AbstractGaiaEntity {
    private static final int DETECTION_RANGE = 6;
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private final StrafeGoal strafeGoal = new StrafeGoal((Mob)this, 1.25, 20, 15.0f);
    private boolean canSpawn;
    private int spawnTimer;
    private int spawnLimit;

    public Deathword(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 20;
        this.canSpawn = true;
        this.spawnTimer = 0;
        this.spawnLimit = 0;
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    @Override
    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return reader.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean isStableDestination(BlockPos pos) {
                return !Deathword.this.level().getBlockState(pos.below()).isAir();
            }

            public void tick() {
                super.tick();
            }
        };
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(false);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FLYING_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.hurt(source, input);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.LEVITATION, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide && this.isPassenger()) {
            this.stopRiding();
        }
        this.beaconMonster(6, entity -> {
            if (!(entity instanceof Player)) {
                entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 1, true, true));
            }
        });
        if (this.playerDetection(6, TargetingConditions.forNonCombat())) {
            if (this.spawnLimit <= 3 && this.canSpawn) {
                if (this.spawnTimer != 60) {
                    ++this.spawnTimer;
                }
                if (this.spawnTimer == 60) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)9);
                    if (!this.level().isClientSide) {
                        switch (this.random.nextInt(4)) {
                            case 0: {
                                boolean flag = EventHooks.canEntityGrief((Level)this.level(), (Entity)this);
                                if (!flag) {
                                    this.setSpawn(0);
                                    break;
                                }
                                this.setSpawn(1);
                                break;
                            }
                            case 1: {
                                this.setSpawn(1);
                                break;
                            }
                            case 2: {
                                this.setSpawn(2);
                                break;
                            }
                            case 3: {
                                this.setSpawn(3);
                                break;
                            }
                        }
                    }
                    this.spawnTimer = 0;
                    ++this.spawnLimit;
                }
            }
            if (this.spawnLimit >= 4 && this.canSpawn) {
                this.setGoals(1);
                this.canSpawn = false;
            }
        }
        Vec3 motion = this.getDeltaMovement();
        if (!this.onGround() && motion.y < 0.0) {
            this.setDeltaMovement(motion.multiply(1.0, 0.6, 1.0));
        }
        motion = this.getDeltaMovement();
        if (motion.x > 0.0 || motion.y > 0.0 || motion.z > 0.0) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
            }
        }
        if (this.isOnFire()) {
            this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0));
            this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0));
        }
        super.aiStep();
    }

    private void setSpawn(int id) {
        if (!this.level().isClientSide) {
            Creeper summon;
            BlockPos blockpos = this.blockPosition().offset(-1 + this.random.nextInt(3), 1, -1 + this.random.nextInt(3));
            if (id == 0 && (summon = (Creeper)EntityType.CREEPER.create(this.level())) != null) {
                summon.moveTo(blockpos, 0.0f, 0.0f);
                EventHooks.finalizeMobSpawn((Mob)summon, (ServerLevelAccessor)((ServerLevel)this.level()), (DifficultyInstance)this.level().getCurrentDifficultyAt(blockpos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null);
                this.level().addFreshEntity((Entity)summon);
            }
            if (id == 1 && (summon = (Skeleton)EntityType.SKELETON.create(this.level())) != null) {
                summon.moveTo(blockpos, 0.0f, 0.0f);
                EventHooks.finalizeMobSpawn((Mob)summon, (ServerLevelAccessor)((ServerLevel)this.level()), (DifficultyInstance)this.level().getCurrentDifficultyAt(blockpos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null);
                summon.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_MOB.get()));
                summon.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
                summon.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
                summon.setDropChance(EquipmentSlot.FEET, 0.0f);
                summon.setDropChance(EquipmentSlot.LEGS, 0.0f);
                summon.setDropChance(EquipmentSlot.CHEST, 0.0f);
                summon.setDropChance(EquipmentSlot.HEAD, 0.0f);
                this.level().addFreshEntity((Entity)summon);
            }
            if (id == 2 && (summon = (Spider)EntityType.SPIDER.create(this.level())) != null) {
                summon.moveTo(blockpos, 0.0f, 0.0f);
                EventHooks.finalizeMobSpawn((Mob)summon, (ServerLevelAccessor)((ServerLevel)this.level()), (DifficultyInstance)this.level().getCurrentDifficultyAt(blockpos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null);
                this.level().addFreshEntity((Entity)summon);
            }
            if (id == 3 && (summon = (Zombie)EntityType.ZOMBIE.create(this.level())) != null) {
                summon.moveTo(blockpos, 0.0f, 0.0f);
                EventHooks.finalizeMobSpawn((Mob)summon, (ServerLevelAccessor)((ServerLevel)this.level()), (DifficultyInstance)this.level().getCurrentDifficultyAt(blockpos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null);
                summon.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_MOB.get()));
                summon.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
                summon.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
                summon.setDropChance(EquipmentSlot.FEET, 0.0f);
                summon.setDropChance(EquipmentSlot.LEGS, 0.0f);
                summon.setDropChance(EquipmentSlot.CHEST, 0.0f);
                summon.setDropChance(EquipmentSlot.HEAD, 0.0f);
                this.level().addFreshEntity((Entity)summon);
            }
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)6);
    }

    private void setGoals(int id) {
        if (id == 0) {
            this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.strafeGoal);
        } else {
            this.goalSelector.removeGoal((Goal)this.strafeGoal);
            this.goalSelector.addGoal(1, (Goal)this.mobAttackGoal);
        }
    }

    private void setCombatTask() {
        this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
        this.goalSelector.removeGoal((Goal)this.strafeGoal);
        this.setGoals(1);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.ZOMBIE_STAFF.get()));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCombatTask();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)GaiaSounds.BOOK_HIT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)GaiaSounds.BOOK_HIT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)GaiaSounds.BOOK_HIT.get();
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double p_27754_, boolean p_27755_, BlockState state, BlockPos pos) {
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkDeathwordSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Deathword.checkDaysPassed(levelAccessor) && Deathword.checkBelowSeaLevel(levelAccessor, pos) && Deathword.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

