/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.attachment.AttachmentHandler;
import gaia.attachment.friended.Friended;
import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.GaiaHorse;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class Centaur
extends AbstractAssistGaiaEntity
implements RangedAttackMob,
IDayMob {
    private static final EntityDataAccessor<Boolean> MALE = SynchedEntityData.defineId(Centaur.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.defineId(Centaur.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RangedBowAttackGoal<Centaur> bowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.275, 20, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private final AvoidEntityGoal<Player> avoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 1.25, 1.3);
    private final AvoidEntityGoal<PathfinderMob> avoidMobGoal = new AvoidEntityGoal((PathfinderMob)this, PathfinderMob.class, 4.0f, 1.25, 1.3);
    private int fullHealth = 0;
    private byte regenerateHealth = 0;

    public Centaur(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.targetSelector.addGoal(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 26.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MALE, (Object)false);
        builder.define(FLEEING, (Object)false);
    }

    public boolean isMale() {
        return (Boolean)this.entityData.get(MALE);
    }

    public void setMale(boolean flag) {
        this.entityData.set(MALE, (Object)flag);
    }

    public boolean isFleeing() {
        return (Boolean)this.entityData.get(FLEEING);
    }

    public void setFleeing(boolean flag) {
        this.entityData.set(FLEEING, (Object)flag);
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.hurt(source, input);
    }

    @Override
    public void aiStep() {
        if (this.getHealth() < this.getMaxHealth() * 0.25f && this.fullHealth == 0) {
            ItemStack stacky = Items.POTION.getDefaultInstance();
            stacky.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.REGENERATION));
            this.setItemSlot(EquipmentSlot.MAINHAND, stacky);
            this.setGoals(1);
            this.setFleeing(true);
            this.fullHealth = 1;
        }
        if (this.getHealth() < this.getMaxHealth() && this.fullHealth == 1) {
            if (this.regenerateHealth <= 100) {
                this.regenerateHealth = (byte)(this.regenerateHealth + 1);
            } else {
                this.playSound(SoundEvents.GENERIC_DRINK, 0.15f, 1.0f);
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 360, 3));
                this.regenerateHealth = 0;
            }
        } else if (this.getHealth() >= this.getMaxHealth() && this.fullHealth == 1) {
            Friended friended = AttachmentHandler.getFriended((LivingEntity)this);
            if (!friended.isFriendly()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
                this.setGoals(0);
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
                this.setGoals(2);
            }
            this.removeEffect(MobEffects.REGENERATION);
            this.setFleeing(false);
            this.fullHealth = 0;
            this.regenerateHealth = 0;
        }
        super.aiStep();
    }

    private void setGoals(int id) {
        switch (id) {
            default: {
                this.goalSelector.removeGoal(this.avoidPlayerGoal);
                this.goalSelector.removeGoal(this.avoidMobGoal);
                this.goalSelector.addGoal(1, this.bowAttackGoal);
                break;
            }
            case 1: {
                this.goalSelector.removeGoal(this.bowAttackGoal);
                this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
                this.goalSelector.addGoal(3, this.avoidPlayerGoal);
                this.goalSelector.addGoal(3, this.avoidMobGoal);
                break;
            }
            case 2: {
                this.goalSelector.removeGoal(this.avoidPlayerGoal);
                this.goalSelector.removeGoal(this.avoidMobGoal);
                this.goalSelector.addGoal(1, (Goal)this.mobAttackGoal);
            }
        }
    }

    private void setCombatTask() {
        this.goalSelector.removeGoal(this.bowAttackGoal);
        this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
        ItemStack itemstack = this.getMainHandItem();
        if (itemstack.getItem() instanceof BowItem) {
            int i = 20;
            if (this.level().getDifficulty() != Difficulty.HARD) {
                i = 40;
            }
            this.bowAttackGoal.setMinAttackInterval(i);
            this.setGoals(0);
        } else {
            this.setGoals(2);
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            RangedUtil.rangedAttack(target, (LivingEntity)this, distanceFactor);
        }
    }

    public ItemStack getProjectile(ItemStack stack) {
        return super.getProjectile(stack);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
        if (random.nextBoolean()) {
            ItemStack tippedArrow = new ItemStack((ItemLike)Items.TIPPED_ARROW);
            if (random.nextInt(2) == 0) {
                tippedArrow.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.SLOWNESS));
                this.setItemSlot(EquipmentSlot.OFFHAND, tippedArrow);
            } else {
                tippedArrow.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WEAKNESS));
                this.setItemSlot(EquipmentSlot.OFFHAND, tippedArrow);
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        GaiaHorse gaiaHorse;
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        if (this.random.nextInt(2) == 0) {
            this.setMale(true);
        }
        if (((Biome)levelAccessor.getBiome(this.blockPosition()).value()).getTemperature(this.blockPosition()) > 1.0f) {
            this.setVariant(1);
        }
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCombatTask();
        if (this.random.nextInt(10000) == 0 && difficultyInstance.getDifficulty() != Difficulty.PEACEFUL && (gaiaHorse = this.createHorse(difficultyInstance)) != null) {
            this.startRiding((Entity)gaiaHorse);
        }
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Male", this.isMale());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Male")) {
            boolean male = tag.getBoolean("Male");
            this.setMale(male);
        }
        this.setGoals(0);
    }

    protected SoundEvent getAmbientSound() {
        return !this.isMale() ? GaiaRegistry.CENTAUR.getSay() : GaiaRegistry.CENTAUR.getMaleSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return !this.isMale() ? GaiaRegistry.CENTAUR.getHurt() : GaiaRegistry.CENTAUR.getMaleHurt();
    }

    protected SoundEvent getDeathSound() {
        return !this.isMale() ? GaiaRegistry.CENTAUR.getDeath() : GaiaRegistry.CENTAUR.getMaleDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkCentaurSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Centaur.checkDaysPassed(levelAccessor) && Centaur.checkDaytime(levelAccessor) && Centaur.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Centaur.checkAboveSeaLevel(levelAccessor, pos) && Centaur.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

