/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.EnchantUtil;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Cecaelia
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> THROWING = SynchedEntityData.defineId(Cecaelia.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 60, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    private int timer;
    private int switchDetect;
    private int switchEquip;
    private boolean animationPlay;
    private int animationTimer;
    private byte inWaterTimer;

    public Cecaelia(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new CecaeliaMermaidMoveControl(this);
        this.setPathfindingMalus(PathType.WATER, 8.0f);
        this.timer = 0;
        this.switchDetect = 0;
        this.switchEquip = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
        this.inWaterTimer = 0;
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 1;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(THROWING, (Object)false);
    }

    public boolean isThrowing() {
        return (Boolean)this.entityData.get(THROWING);
    }

    public void setThrowing(boolean flag) {
        this.entityData.set(THROWING, (Object)flag);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            RangedUtil.bubble(target, (LivingEntity)this, distanceFactor);
            this.setThrowing(true);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, effectTime * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide && this.isInWater()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)8);
                this.heal(this.getMaxHealth() * 0.1f);
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.playerDetection(3, TargetingConditions.forCombat())) {
            if (this.switchDetect == 0) {
                this.switchDetect = 1;
            }
        } else if (this.switchDetect == 1) {
            this.switchDetect = 0;
        }
        if (this.switchDetect == 1 && this.switchEquip == 0) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (!this.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                    this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 0));
                }
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.METAL_DAGGER.get()));
                this.setGoals(1);
                this.timer = 0;
                this.switchEquip = 1;
            }
        }
        if (this.switchDetect == 0 && this.switchEquip == 1) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (this.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                    this.removeEffect(MobEffects.MOVEMENT_SPEED);
                }
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                this.setGoals(0);
                this.timer = 0;
                this.switchEquip = 0;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setThrowing(false);
                this.animationPlay = false;
            }
        }
        super.aiStep();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.mobAttackGoal);
        } else {
            this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.rangedAttackGoal);
            this.setThrowing(false);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    boolean wantsToSwim() {
        LivingEntity livingentity = this.getTarget();
        return livingentity != null && livingentity.isInWater();
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigation;
                this.setSwimming(false);
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        ItemStack itemstack = this.getMainHandItem();
        if (itemstack.isEmpty()) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
        ItemStack swimmingBoots = new ItemStack((ItemLike)Items.LEATHER_BOOTS);
        this.setItemSlot(EquipmentSlot.FEET, swimmingBoots);
        swimmingBoots.enchant(EnchantUtil.getEnchantmentHolder((Entity)this, (ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER), 2);
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.CECAELIA.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.CECAELIA.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.CECAELIA.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Override
    public boolean canAttackType(EntityType<?> type) {
        return super.canAttackType(type) && type != GaiaRegistry.CECAELIA.getEntityType();
    }

    public boolean checkSpawnObstruction(LevelReader reader) {
        return reader.isUnobstructed((Entity)this);
    }

    public static boolean checkCecaeliaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean daysPassed = Cecaelia.checkDaysPassed(levelAccessor);
        boolean isNight = !Cecaelia.checkDaytime(levelAccessor);
        boolean inWater = Cecaelia.checkInWater((LevelAccessor)levelAccessor, pos, 5);
        boolean darkEnough = Cecaelia.isDarkEnoughToSpawn((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)random);
        boolean notPeaceful = Cecaelia.checkNotPeaceful((LevelAccessor)levelAccessor);
        boolean matchRandom = random.nextInt(15) == 0;
        return matchRandom && daysPassed && isNight && inWater && darkEnough && notPeaceful;
    }

    static class CecaeliaMermaidMoveControl
    extends MoveControl {
        private final Cecaelia cecaelia;

        public CecaeliaMermaidMoveControl(Cecaelia cecaelia) {
            super((Mob)cecaelia);
            this.cecaelia = cecaelia;
        }

        public void tick() {
            LivingEntity livingentity = this.cecaelia.getTarget();
            if (this.cecaelia.wantsToSwim() && this.cecaelia.isInWater()) {
                if (livingentity != null && livingentity.getY() > this.cecaelia.getY()) {
                    this.cecaelia.setDeltaMovement(this.cecaelia.getDeltaMovement().add(0.0, 0.002, 0.0));
                }
                if (this.operation != MoveControl.Operation.MOVE_TO || this.cecaelia.getNavigation().isDone()) {
                    this.cecaelia.setSpeed(0.0f);
                    return;
                }
                double d0 = this.wantedX - this.cecaelia.getX();
                double d1 = this.wantedY - this.cecaelia.getY();
                double d2 = this.wantedZ - this.cecaelia.getZ();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.cecaelia.setYRot(this.rotlerp(this.cecaelia.getYRot(), f, 90.0f));
                this.cecaelia.yBodyRot = this.cecaelia.getYRot();
                float f1 = (float)(this.speedModifier * this.cecaelia.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float f2 = Mth.lerp((float)0.125f, (float)this.cecaelia.getSpeed(), (float)f1);
                this.cecaelia.setSpeed(f2);
                this.cecaelia.setDeltaMovement(this.cecaelia.getDeltaMovement().add((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.cecaelia.onGround()) {
                    this.cecaelia.setDeltaMovement(this.cecaelia.getDeltaMovement().add(0.0, -0.008, 0.0));
                }
                super.tick();
            }
        }
    }
}

