/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Banshee
extends AbstractGaiaEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Banshee.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    @Nullable
    private BlockPos boundOrigin;

    public Banshee(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new BansheeMoveControl(this);
        this.xpReward = 20;
    }

    public void move(MoverType moverType, Vec3 pos) {
        super.move(moverType, pos);
        this.checkInsideBlocks();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BansheeChargeAttackGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BansheeRandomMoveGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.275).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pos) {
        this.boundOrigin = pos;
    }

    private boolean getBansheeFlag(int mask) {
        byte i = (Byte)this.entityData.get(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setBansheeFlag(int mask, boolean value) {
        int i = ((Byte)this.entityData.get(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getBansheeFlag(1);
    }

    public void setIsCharging(boolean charging) {
        this.setBansheeFlag(1, charging);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        Entity entity = source.getDirectEntity();
        if (entity instanceof Arrow) {
            input += 2.0f;
        }
        if (entity instanceof SpectralArrow) {
            input += 4.0f;
        }
        return super.hurt(source, input);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            entityIn.setRemainingFireTicks(120);
            return true;
        }
        return false;
    }

    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide) {
            if (this.isPassenger()) {
                this.stopRiding();
            }
            if (this.isAlive() && this.isSunBurnTick()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)11);
                this.hurt(this.damageSources().fellOutOfWorld(), this.getMaxHealth() * 0.25f);
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
        }
        super.aiStep();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.boundOrigin != null) {
            tag.putInt("BoundX", this.boundOrigin.getX());
            tag.putInt("BoundY", this.boundOrigin.getY());
            tag.putInt("BoundZ", this.boundOrigin.getZ());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("BoundX")) {
            this.boundOrigin = new BlockPos(tag.getInt("BoundX"), tag.getInt("BoundY"), tag.getInt("BoundZ"));
        }
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.BANSHEE.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.BANSHEE.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.BANSHEE.getDeath();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public static boolean checkBansheeSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Banshee.checkDaysPassed(levelAccessor) && Banshee.checkAboveSeaLevel(levelAccessor, pos) && Banshee.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    static class BansheeMoveControl
    extends MoveControl {
        public BansheeMoveControl(Banshee banshee) {
            super((Mob)banshee);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.wantedX - this.mob.getX(), this.wantedY - this.mob.getY(), this.wantedZ - this.mob.getZ());
                double d0 = vec3.length();
                if (d0 < this.mob.getBoundingBox().getSize()) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.mob.setDeltaMovement(this.mob.getDeltaMovement().scale(0.5));
                } else {
                    this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(vec3.scale(this.speedModifier * 0.05 / d0)));
                    if (this.mob.getTarget() == null) {
                        Vec3 vec31 = this.mob.getDeltaMovement();
                        this.mob.setYRot(-((float)Mth.atan2((double)vec31.x, (double)vec31.z)) * 57.295776f);
                        this.mob.yBodyRot = this.mob.getYRot();
                    } else {
                        double d2 = this.mob.getTarget().getX() - this.mob.getX();
                        double d1 = this.mob.getTarget().getZ() - this.mob.getZ();
                        this.mob.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                        this.mob.yBodyRot = this.mob.getYRot();
                    }
                }
            }
        }
    }

    static class BansheeChargeAttackGoal
    extends Goal {
        protected final Banshee banshee;

        public BansheeChargeAttackGoal(Banshee banshee) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.banshee = banshee;
        }

        public boolean canUse() {
            if (this.banshee.getTarget() != null && !this.banshee.getMoveControl().hasWanted() && this.banshee.getRandom().nextInt(BansheeChargeAttackGoal.reducedTickDelay((int)7)) == 0) {
                return this.banshee.distanceToSqr((Entity)this.banshee.getTarget()) > 4.0;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.banshee.getMoveControl().hasWanted() && this.banshee.isCharging() && this.banshee.getTarget() != null && this.banshee.getTarget().isAlive();
        }

        public void start() {
            LivingEntity livingentity = this.banshee.getTarget();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.getEyePosition();
                this.banshee.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, 1.0);
            }
            this.banshee.setIsCharging(true);
            this.banshee.playSound(SoundEvents.VEX_CHARGE, 1.0f, 1.0f);
        }

        public void stop() {
            this.banshee.setIsCharging(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.banshee.getTarget();
            if (livingentity != null) {
                if (this.banshee.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    this.banshee.doHurtTarget((Entity)livingentity);
                    this.banshee.setIsCharging(false);
                } else {
                    double d0 = this.banshee.distanceToSqr((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vec3 = livingentity.getEyePosition();
                        this.banshee.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, 1.0);
                    }
                }
            }
        }
    }

    static class BansheeRandomMoveGoal
    extends Goal {
        protected final Banshee banshee;

        public BansheeRandomMoveGoal(Banshee banshee) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.banshee = banshee;
        }

        public boolean canUse() {
            return !this.banshee.getMoveControl().hasWanted() && this.banshee.getRandom().nextInt(BansheeRandomMoveGoal.reducedTickDelay((int)7)) == 0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void tick() {
            BlockPos blockpos = this.banshee.getBoundOrigin();
            if (blockpos == null) {
                blockpos = this.banshee.blockPosition();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.offset(this.banshee.random.nextInt(15) - 7, this.banshee.random.nextInt(11) - 5, this.banshee.random.nextInt(15) - 7);
                if (!this.banshee.level().isEmptyBlock(blockpos1)) continue;
                this.banshee.getMoveControl().setWantedPosition((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5, 0.25);
                if (this.banshee.getTarget() != null) break;
                this.banshee.getLookControl().setLookAt((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

