/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.EnchantUtil;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Arachne
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Arachne.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(Arachne.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final MobAttackGoal collideAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int switchHealth = 0;
    private int spawn = 0;
    private int spawnTimer = 0;
    private boolean animationPlay = false;
    private int animationTimer = 0;

    public Arachne(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    protected PathNavigation createNavigation(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(ATTACK_TYPE, (Object)0);
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.hurt(source, input);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            RangedUtil.web(target, (LivingEntity)this, distanceFactor);
            this.setAttackType(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    @Override
    public boolean canAttackType(EntityType<?> type) {
        return super.canAttackType(type) && type != GaiaRegistry.ARACHNE.getEntityType();
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectTime * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        this.beaconMonster(6, entity -> {
            if (entity instanceof Spider) {
                entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, 1, true, true));
            }
        });
        if (this.getHealth() < this.getMaxHealth() * 0.5f && this.switchHealth == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.METAL_DAGGER.get()));
            this.setGoals(1);
            this.switchHealth = 1;
        }
        if (this.getHealth() > this.getMaxHealth() * 0.5f && this.switchHealth == 1) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.CAVE_SPIDER_STAFF.get()));
            this.setGoals(0);
            this.switchHealth = 0;
        }
        if (this.getHealth() < this.getMaxHealth() * 0.75f && this.getHealth() > 0.0f && this.spawn == 0) {
            this.setAttackType(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.level().broadcastEntityEvent((Entity)this, (byte)9);
                this.setAttackType(0);
                if (!this.level().isClientSide) {
                    this.setSpawn(0);
                }
                this.spawnTimer = 0;
                this.spawn = 1;
            }
        }
        if (this.getHealth() < this.getMaxHealth() * 0.25f && this.getHealth() > 0.0f && this.spawn == 1) {
            this.setAttackType(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.level().broadcastEntityEvent((Entity)this, (byte)9);
                this.setAttackType(0);
                if (!this.level().isClientSide) {
                    this.setSpawn(0);
                }
                this.spawnTimer = 0;
                this.spawn = 2;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAttackType(0);
                this.animationPlay = false;
            }
        }
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
        }
        super.aiStep();
    }

    private void setSpawn(int id) {
        CaveSpider caveSpider;
        if (this.level().getDifficulty() != Difficulty.PEACEFUL && id == 0 && (caveSpider = (CaveSpider)EntityType.CAVE_SPIDER.create(this.level())) != null) {
            caveSpider.moveTo(this.blockPosition(), 0.0f, 0.0f);
            caveSpider.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null);
            this.level().addFreshEntity((Entity)caveSpider);
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)6);
    }

    private void setCombatTask() {
        ItemStack itemstack = this.getMainHandItem();
        if (itemstack.is((Item)GaiaRegistry.CAVE_SPIDER_STAFF.get())) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.collideAttackGoal);
        } else {
            this.goalSelector.removeGoal((Goal)this.collideAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.rangedAttackGoal);
            this.setAttackType(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean value) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = value ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.random.nextInt(2) == 0 ? super.getDefaultLootTable() : EntityType.WITCH.getDefaultLootTable();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        ItemStack staffStack = new ItemStack((ItemLike)GaiaRegistry.CAVE_SPIDER_STAFF.get());
        staffStack.enchant(EnchantUtil.getEnchantmentHolder((Entity)this, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK), 2);
        this.setItemSlot(EquipmentSlot.MAINHAND, staffStack);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("WeaponType", this.getAttackType());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("WeaponType")) {
            this.setAttackType(tag.getInt("WeaponType"));
        }
        this.setCombatTask();
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.ARACHNE.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.ARACHNE.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.ARACHNE.getDeath();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.SPIDER_STEP, 0.15f, 1.0f);
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public void makeStuckInBlock(BlockState state, Vec3 speedMultiplier) {
        if (!state.is(Blocks.COBWEB)) {
            super.makeStuckInBlock(state, speedMultiplier);
        }
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return effectInstance.getEffect() != MobEffects.POISON && super.canBeAffected(effectInstance);
    }

    public boolean fireImmune() {
        return true;
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkArachneSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Arachne.checkDaysPassed(levelAccessor) && Arachne.checkBelowSeaLevel(levelAccessor, pos) && Arachne.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

