/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.server;

import gaia.registry.GaiaRegistry;
import gaia.registry.helper.MobReg;
import gaia.registry.helper.PropReg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class GaiaAdvancementProvider
extends AdvancementProvider {
    public static final Map<EntityType<?>, AdvancementHolder> entityTypeAdvancementMap = new HashMap();

    public GaiaAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new GaiaAdvancementGenerator()));
    }

    public static class GaiaAdvancementGenerator
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            AdvancementHolder root = Advancement.Builder.advancement().display(GaiaAdvancementGenerator.rootDisplay((ItemLike)GaiaRegistry.DOLL_DRYAD.get(), GaiaAdvancementGenerator.advancementPrefix("root.title"), GaiaAdvancementGenerator.advancementPrefix("root.desc"), GaiaAdvancementGenerator.modLoc("textures/block/pearl_block_bottom.png"))).addCriterion("join", EnterBlockTrigger.TriggerInstance.entersBlock((Block)Blocks.AIR)).save(consumer, GaiaAdvancementGenerator.rootID("root"));
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ANT_SALVAGER, (Item)GaiaRegistry.PROJECTILE_POISON.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ANT_WORKER, Items.GREEN_DYE, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ANUBIS, (Item)GaiaRegistry.SKELETON_STAFF.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ARACHNE, (Item)GaiaRegistry.CAVE_SPIDER_STAFF.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.BANSHEE, (Item)GaiaRegistry.SOULFIRE.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.BEHENDER, (Item)GaiaRegistry.WEAPON_BOOK_ENDER.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.BONE_KNIGHT, (Item)GaiaRegistry.BONE_SHIELD.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.CECAELIA, (Item)GaiaRegistry.SHINY_PEARL.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.COBBLESTONE_GOLEM, (Item)GaiaRegistry.WEAPON_BOOK_METAL.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.CREEP, (Item)GaiaRegistry.DOLL_CREEPER_GIRL_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.CYAN_FLOWER, (Item)GaiaRegistry.MANDRAKE.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.DEATHWORD, Items.PAPER, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.DULLAHAN, (Item)GaiaRegistry.DOLL_DULLAHAN_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ENDER_EYE, Items.ENDER_PEARL, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.FLESH_LICH, (Item)GaiaRegistry.ZOMBIE_STAFF.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.GELATINOUS_SLIME, (Item)GaiaRegistry.DOLL_SLIME_GIRL_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.GOBLIN_FERAL, Items.WOODEN_AXE, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.GRAVEMITE, Items.COBBLESTONE, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.HARPY, (Item)GaiaRegistry.DECO_NEST_HARPY_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.KOBOLD, Items.BOW, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MANDRAGORA, (Item)GaiaRegistry.DECO_GARDEN_GNOME_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MATANGO, Items.RED_MUSHROOM, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MIMIC, Items.CHEST, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MINOTAUR, (Item)GaiaRegistry.MINOTAUR_HAMMER.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MINOTAURUS, (Item)GaiaRegistry.WEAPON_BOOK_BATTLE.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.MUMMY, Items.ROTTEN_FLESH, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.NAGA, (Item)GaiaRegistry.GOLD_SHIELD.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.NINE_TAILS, (Item)GaiaRegistry.DOLL_NINE_TAILS_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ONI, (Item)GaiaRegistry.METAL_CLUB.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.ORC, Items.STONE_AXE, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SHAMAN, (Item)GaiaRegistry.ROTTEN_HEART.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SHARKO, (Item)GaiaRegistry.SHINY_PEARL.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SIREN, Items.COD, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SLUDGE_GIRL, Items.SLIME_BALL, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SPHINX, (Item)GaiaRegistry.BUST_SPHINX_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SPORELING, Items.BROWN_MUSHROOM, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SPRIGGAN, Items.OAK_LOG, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.SUCCUBUS, (Item)GaiaRegistry.FIRESHARD.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.TOAD, Items.SLIME_BALL, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.VALKYRIE, (Item)GaiaRegistry.BUST_VALKYRIE_ITEM.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.WERECAT, (Item)GaiaRegistry.MEAT.get(), root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.WITCH, Items.POTION, root);
            GaiaAdvancementGenerator.addKillAdvancement(consumer, GaiaRegistry.WITHER_COW, (Item)GaiaRegistry.WITHERED_BRAIN.get(), root);
        }

        protected static void addKillAdvancement(Consumer<AdvancementHolder> consumer, MobReg<? extends LivingEntity> mobReg, @Nullable Item item, AdvancementHolder root) {
            ResourceLocation registryLocation = GaiaAdvancementGenerator.modLoc(mobReg.getName());
            Item icon = item != null ? item : mobReg.getSpawnEgg().asOptional().orElse(Items.EGG);
            AdvancementHolder advancement = Advancement.Builder.advancement().display(GaiaAdvancementGenerator.simpleDisplay((ItemLike)icon, registryLocation.getPath())).parent(root).addCriterion("kill", GaiaAdvancementGenerator.onKill(mobReg.getEntityType())).save(consumer, GaiaAdvancementGenerator.rootID(registryLocation.getPath()));
            entityTypeAdvancementMap.put(mobReg.getEntityType(), advancement);
        }

        protected static void addKillAdvancement(Consumer<AdvancementHolder> consumer, PropReg<? extends LivingEntity> propReg, @Nullable Item item, AdvancementHolder root) {
            ResourceLocation registryLocation = GaiaAdvancementGenerator.modLoc(propReg.getName());
            Item icon = item != null ? item : propReg.getSpawnEgg().asOptional().orElse(Items.EGG);
            AdvancementHolder advancement = Advancement.Builder.advancement().display(GaiaAdvancementGenerator.simpleDisplay((ItemLike)icon, registryLocation.getPath())).parent(root).addCriterion("kill", GaiaAdvancementGenerator.onKill(propReg.getEntityType())).save(consumer, GaiaAdvancementGenerator.rootID(registryLocation.getPath()));
            entityTypeAdvancementMap.put(propReg.getEntityType(), advancement);
        }

        protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)titleKey), (Component)Component.translatable((String)descKey), Optional.of(background), AdvancementType.TASK, false, false, false);
        }

        protected static DisplayInfo simpleDisplay(ItemLike icon, String name) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)GaiaAdvancementGenerator.advancementPrefix(name + ".title")), (Component)Component.translatable((String)GaiaAdvancementGenerator.advancementPrefix(name + ".desc")), Optional.empty(), AdvancementType.TASK, true, false, false);
        }

        protected static Criterion<KilledTrigger.TriggerInstance> onKill(EntityType<?> entityType) {
            return KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityType));
        }

        private static ResourceLocation modLoc(String path) {
            return ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)path);
        }

        private static String advancementPrefix(String name) {
            return "advancement.grimoireofgaia." + name;
        }

        private static String rootID(String name) {
            return GaiaAdvancementGenerator.modLoc("main/" + name).toString();
        }
    }
}

