/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.client.compat;

import gaia.datagen.server.GaiaAdvancementProvider;
import gaia.registry.GaiaRegistry;
import gaia.registry.helper.MobReg;
import gaia.registry.helper.PropReg;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import xyz.brassgoggledcoders.patchouliprovider.BookBuilder;
import xyz.brassgoggledcoders.patchouliprovider.CategoryBuilder;
import xyz.brassgoggledcoders.patchouliprovider.EntryBuilder;
import xyz.brassgoggledcoders.patchouliprovider.PatchouliBookProvider;
import xyz.brassgoggledcoders.patchouliprovider.page.EntityPageBuilder;

public class GaiaPatchouliProvider
extends PatchouliBookProvider {
    public GaiaPatchouliProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, "grimoireofgaia", "en_us", lookupProvider);
    }

    protected void addBooks(Consumer<BookBuilder> consumer, HolderLookup.Provider provider) {
        BookBuilder bookBuilder = this.createBookBuilder("gaiapedia", this.prefix("name"), this.prefix("landing"), provider).setSubtitle(this.prefix("subtitle")).setCreativeTab("grimoireofgaia:tab").setModel("patchouli:book_red").setBookTexture("patchouli:textures/gui/book_red.png").setShowProgress(true).setI18n(true).setVersion("Alpha 30").addMacro("$(item)", "$(#b0b)").addMacro("$(mob)", "$(#e50)").addMacro("$(thing)", "$(#490)").setUseResourcePack(true);
        CategoryBuilder assistCategory = bookBuilder.addCategory("assist", this.prefix("category.assist.name"), this.prefix("category.assist.desc"), new ItemStack((ItemLike)Items.OAK_SAPLING));
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.CENTAUR), 0.75f, 0.0f, Items.LEATHER, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.BAG_ARROWS.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.COBBLE_GOLEM), 1.0f, 0.0f, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get());
        ItemStack sharpnessBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        sharpnessBook.enchant(provider.holderOrThrow(Enchantments.SHARPNESS), 1);
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.CYCLOPS), 1.0f, 0.0f, new ItemStack((ItemLike)GaiaRegistry.FUR.get()), new ItemStack((ItemLike)Items.IRON_NUGGET), new ItemStack((ItemLike)GaiaRegistry.BOX_IRON.get()), sharpnessBook, new ItemStack((ItemLike)GaiaRegistry.KNUCKLES.get()));
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.DRYAD), 1.0f, 0.0f, (Item)GaiaRegistry.TAPROOT.get(), Items.DARK_OAK_LOG, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.DOLL_DRYAD_ITEM.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.DWARF), 0.75f, 0.0f, (Item)GaiaRegistry.BOX_OVERWORLD.get(), (Item)GaiaRegistry.BOX_GOLD.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.ENDER_DRAGON_GIRL), 1.0f, 0.0f, Items.ENDER_PEARL, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_END.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.DOLL_ENDER_GIRL_ITEM.get(), (Item)GaiaRegistry.ELYTRA_FRAGMENT.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.GOBLIN), 1.0f, 0.0f, Items.IRON_NUGGET, (Item)GaiaRegistry.MEAT.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.GRYPHON), 0.75f, 0.0f, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.BEE), 1.0f, 0.0f, (Item)GaiaRegistry.HONEYDEW.get(), (Item)GaiaRegistry.BOX_IRON.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.HUNTER), 1.0f, 0.0f, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.BAG_ARROWS.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.MERMAID), 1.0f, 0.0f, (Item)GaiaRegistry.SHINY_PEARL.get(), (Item)GaiaRegistry.BOX_IRON.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.SATYRESS), 1.0f, 0.0f, (Item)GaiaRegistry.MEAT.get(), (Item)GaiaRegistry.BOX_IRON.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.VALKYRIE), 1.0f, 0.0f, (Item)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get(), (Item)GaiaRegistry.DIAMOND_SHARD.get(), (Item)GaiaRegistry.EMERALD_SHARD.get(), (Item)GaiaRegistry.BOX_DIAMOND.get(), (Item)GaiaRegistry.BUST_VALKYRIE_ITEM.get(), (Item)GaiaRegistry.RING_OF_SPEED.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.WIZARD_HARPY), 1.0f, 0.0f, (Item)GaiaRegistry.SOULFIRE.get(), (Item)GaiaRegistry.BOOK_OF_MEMORY.get());
        assistCategory = this.addExtendedMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.YUKI_ONNA), 1.0f, 0.0f, (Item)GaiaRegistry.FUR.get(), (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.FAN_ICE.get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.TRADER), 1.0f, 0.0f, (Item)GaiaRegistry.TRADER.getSpawnEgg().get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.ENDER_GIRL), 1.0f, 0.0f, (Item)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.SLIME_GIRL), 1.0f, 0.0f, (Item)GaiaRegistry.SLIME_GIRL.getSpawnEgg().get());
        assistCategory = this.addMobEntry(assistCategory, "assist", this.generateHelper(GaiaRegistry.ENDER_GIRL), 1.0f, 0.0f, (Item)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get());
        bookBuilder = assistCategory.build();
        CategoryBuilder hostileCategory = bookBuilder.addCategory("hostile", this.prefix("category.hostile.name"), this.prefix("category.hostile.desc"), "minecraft:stone_axe");
        ItemStack lootingBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        lootingBook.enchant(provider.holderOrThrow(Enchantments.LOOTING), 1);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.ANT_SALVAGER), 0.5f, -0.5f, new ItemStack((ItemLike)GaiaRegistry.MEAT.get()), new ItemStack((ItemLike)Items.IRON_NUGGET), new ItemStack((ItemLike)GaiaRegistry.BAG_BOOK.get()), lootingBook);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.ANT_WORKER), 1.0f, 0.0f, Items.GREEN_DYE, (Item)GaiaRegistry.HONEYDEW.get(), Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.ANUBIS), 1.0f, 0.0f, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.BOOK_OF_MEMORY.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.ARACHNE), 1.0f, 0.0f, (Item)GaiaRegistry.STONE_COAL.get(), Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_OVERWORLD.get(), (Item)GaiaRegistry.BOOK_OF_MEMORY.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.BANSHEE), 0.8f, 0.0f, (Item)GaiaRegistry.SOULFIRE.get(), Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.BEHENDER), 1.0f, -0.5f, Items.ENDER_PEARL, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_END.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.WEAPON_BOOK_ENDER.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.BONE_KNIGHT), 1.0f, 0.0f, Items.REDSTONE, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_OVERWORLD.get(), Items.REDSTONE_BLOCK, Items.SKELETON_SKULL);
        ItemStack fishingLuckBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        fishingLuckBook.enchant(provider.holderOrThrow(Enchantments.LUCK_OF_THE_SEA), 1);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.CECAELIA), 1.0f, 0.0f, new ItemStack((ItemLike)GaiaRegistry.SHINY_PEARL.get()), new ItemStack((ItemLike)Items.CLAY), new ItemStack((ItemLike)Items.IRON_NUGGET), fishingLuckBook);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.COBBLESTONE_GOLEM), 1.0f, 0.0f, Items.IRON_NUGGET, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.CHEST_JUNGLE.get(), (Item)GaiaRegistry.TOTEM_FRAGMENT.get(), (Item)GaiaRegistry.WEAPON_BOOK_METAL.get());
        hostileCategory = this.addExtendedLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.CYAN_FLOWER), 1.0f, 0.0f, Items.POPPY, Items.DANDELION, (Item)GaiaRegistry.MANDRAKE.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.CREEP), 0.5f, 0.0f, Items.GUNPOWDER, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_OVERWORLD.get(), (Item)GaiaRegistry.DOLL_CREEPER_GIRL_ITEM.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.DEATHWORD), 1.0f, 0.0f, Items.PAPER, Items.BOOK, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_OVERWORLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.WEAPON_BOOK.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.DULLAHAN), 1.0f, 0.0f, (Item)GaiaRegistry.SOULFIRE.get(), Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.DOLL_DULLAHAN_ITEM.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.ENDER_EYE), 1.0f, 0.0f, Items.ENDER_PEARL, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.DOLL_ENDER_GIRL_ITEM.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.FLESH_LICH), 1.0f, 0.0f, Items.LAPIS_LAZULI, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_OVERWORLD.get(), Items.LAPIS_BLOCK, Items.ZOMBIE_HEAD);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.GELATINOUS_SLIME), 0.5f, 0.0f, Items.SLIME_BALL, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.DOLL_SLIME_GIRL_ITEM.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.GOBLIN_FERAL), 1.0f, 0.0f, Items.IRON_NUGGET);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.GRAVEMITE), 1.0f, 0.0f, Items.AIR);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.HARPY), 1.0f, 0.0f, Items.FEATHER, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.DECO_NEST_HARPY_ITEM.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.KOBOLD), 1.0f, 0.0f, (Item)GaiaRegistry.FUR.get(), Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.BAG_ARROWS.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.MANDRAGORA), 1.0f, 0.0f, (Item)GaiaRegistry.TAPROOT.get(), (Item)GaiaRegistry.MANDRAKE.get(), Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.DECO_GARDEN_GNOME_ITEM.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.MATANGO), 1.0f, 0.0f, Items.RED_MUSHROOM, Items.BROWN_MUSHROOM, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get());
        hostileCategory = this.addExtendedLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.MIMIC), 1.0f, 0.0f, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_OVERWORLD.get(), (Item)GaiaRegistry.PREMIUM_MONSTER_FEED.get(), (Item)GaiaRegistry.BAG_RECORD.get(), (Item)GaiaRegistry.WEAPON_BOOK_HUNGER.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.MINOTAUR), 1.0f, 0.0f, (Item)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get(), (Item)GaiaRegistry.DIAMOND_SHARD.get(), (Item)GaiaRegistry.EMERALD_SHARD.get(), (Item)GaiaRegistry.BOX_DIAMOND.get(), (Item)GaiaRegistry.BUST_MINOTAUR_ITEM.get(), (Item)GaiaRegistry.HEAVY_BARBELL.get(), (Item)GaiaRegistry.RING_OF_HASTE.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.MINOTAURUS), 1.0f, 0.0f, Items.LEATHER, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.WEAPON_BOOK_BATTLE.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.MUMMY), 1.0f, 0.0f, Items.ROTTEN_FLESH, Items.BONE, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.NAGA), 1.0f, 0.0f, Items.COD, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.NINE_TAILS), 1.0f, 0.0f, (Item)GaiaRegistry.SOULFIRE.get(), Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.FAN_FIRE.get(), (Item)GaiaRegistry.DOLL_NINE_TAILS_ITEM.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.ONI), 1.0f, 0.0f, new ItemStack((ItemLike)GaiaRegistry.SOULFIRE.get()), new ItemStack((ItemLike)Items.IRON_NUGGET), new ItemStack((ItemLike)GaiaRegistry.BOX_IRON.get()), sharpnessBook);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.ORC), 1.0f, 0.0f, (Item)GaiaRegistry.MEAT.get(), Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.BAG_BOOK.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.SHAMAN), 0.75f, 0.0f, (Item)GaiaRegistry.ROTTEN_HEART.get(), Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.BOOK_OF_MEMORY.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.SHARKO), 1.0f, 0.0f, (Item)GaiaRegistry.SHINY_PEARL.get(), Items.PRISMARINE_SHARD, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_OVERWORLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.WEAPON_BOOK_BUFF.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.SIREN), 1.0f, 0.0f, Items.COD, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get(), (Item)GaiaRegistry.BAG_ARROWS.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.SLUDGE_GIRL), 0.9f, 0.0f, Items.SLIME_BALL, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.SPHINX), 1.0f, 0.0f, (Item)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get(), (Item)GaiaRegistry.DIAMOND_SHARD.get(), (Item)GaiaRegistry.EMERALD_SHARD.get(), (Item)GaiaRegistry.BOX_DIAMOND.get(), (Item)GaiaRegistry.BUST_SPHINX_ITEM.get(), (Item)GaiaRegistry.RING_OF_JUMP.get(), (Item)GaiaRegistry.CHEST_DESERT.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.SPORELING), 1.0f, 0.0f, Items.AIR);
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.SPRIGGAN), 1.0f, 0.0f, (Item)GaiaRegistry.TAPROOT.get(), Items.OAK_LOG, Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.WEAPON_BOOK_NATURE.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.SUCCUBUS), 1.0f, 0.0f, (Item)GaiaRegistry.FIRESHARD.get(), Items.QUARTZ, Items.GLOWSTONE_DUST, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_NETHER.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.TOAD), 1.0f, 0.0f, Items.SLIME_BALL, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.WERECAT), 1.0f, 0.0f, (Item)GaiaRegistry.MEAT.get(), Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_IRON.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.WITCH), 0.75f, 0.0f, (Item)GaiaRegistry.NETHER_WART_JAM.get(), Items.GOLD_NUGGET, (Item)GaiaRegistry.BOX_GOLD.get(), (Item)GaiaRegistry.BAG_BOOK.get(), (Item)GaiaRegistry.BOOK_OF_MEMORY.get(), (Item)GaiaRegistry.DECO_MANDRAGORA_POT_ITEM.get());
        hostileCategory = this.addLockedMobEntry(hostileCategory, "hostile", this.generateHelper(GaiaRegistry.WITHER_COW), 1.0f, 0.0f, (Item)GaiaRegistry.WITHERED_BRAIN.get(), Items.QUARTZ, Items.GLOWSTONE_DUST, Items.IRON_NUGGET, (Item)GaiaRegistry.BOX_NETHER.get());
        bookBuilder = hostileCategory.build();
        bookBuilder.build(consumer);
    }

    private CategoryBuilder addMobEntry(CategoryBuilder builder, String category, RegHelper mobReg, boolean extraPage, float scale, float offset, ItemStack ... drops) {
        String path = mobReg.name();
        String entryPrefix = "entry." + path;
        EntryBuilder entryBuilder = builder.addEntry(category + "/" + path, this.prefix(entryPrefix + ".name"), mobReg.spawnEgg().getId().toString()).addTextPage(this.prefix(entryPrefix + ".info")).build();
        EntityPageBuilder entityBuilder = entryBuilder.addEntityPage(BuiltInRegistries.ENTITY_TYPE.getKey(mobReg.entityType())).setText(this.prefix(entryPrefix + ".info2"));
        if (scale != 1.0f) {
            entityBuilder.setScale(Float.valueOf(scale));
        }
        if (offset != 0.0f) {
            entityBuilder.setOffset(Float.valueOf(offset));
        }
        entityBuilder.build();
        if (extraPage) {
            entryBuilder.addTextPage(this.prefix(entryPrefix + ".info3")).build();
        }
        for (ItemStack stack : drops) {
            if (stack.getItem() == Items.AIR) break;
            entryBuilder.addSpotlightPage(stack).setLinkRecipe(Boolean.valueOf(true)).setText(this.prefix("drop." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".info")).build();
        }
        return entryBuilder.build();
    }

    private CategoryBuilder addMobEntry(CategoryBuilder builder, String category, RegHelper mobReg, float scale, float offset, ItemStack ... drops) {
        return this.addMobEntry(builder, category, mobReg, false, scale, offset, drops);
    }

    private CategoryBuilder addMobEntry(CategoryBuilder builder, String category, RegHelper mobReg, float scale, float offset, Item ... drops) {
        return this.addMobEntry(builder, category, mobReg, false, scale, offset, Arrays.stream(drops).map(item -> new ItemStack((ItemLike)item)).toList().toArray(new ItemStack[0]));
    }

    private CategoryBuilder addExtendedMobEntry(CategoryBuilder builder, String category, RegHelper mobReg, float scale, float offset, Item ... drops) {
        return this.addMobEntry(builder, category, mobReg, true, scale, offset, Arrays.stream(drops).map(item -> new ItemStack((ItemLike)item)).toList().toArray(new ItemStack[0]));
    }

    private CategoryBuilder addLockedMobEntry(CategoryBuilder builder, String category, RegHelper mobReg, boolean extraPage, float scale, float offset, ItemStack ... drops) {
        String path = mobReg.name();
        String entryPrefix = "entry." + path;
        String advancement = GaiaAdvancementProvider.entityTypeAdvancementMap.get(mobReg.entityType()).id().toString();
        EntryBuilder entryBuilder = builder.addEntry(category + "/" + path, this.prefix(entryPrefix + ".name"), mobReg.spawnEgg().getId().toString()).setAdvancement(advancement).addTextPage(this.prefix(entryPrefix + ".info")).build();
        EntityPageBuilder entityBuilder = entryBuilder.addEntityPage(BuiltInRegistries.ENTITY_TYPE.getKey(mobReg.entityType())).setText(this.prefix(entryPrefix + ".info2"));
        if (scale != 1.0f) {
            entityBuilder.setScale(Float.valueOf(scale));
        }
        if (offset != 0.0f) {
            entityBuilder.setOffset(Float.valueOf(offset));
        }
        entityBuilder.build();
        if (extraPage) {
            entryBuilder.addTextPage(this.prefix(entryPrefix + ".info3")).build();
        }
        for (ItemStack stack : drops) {
            if (stack.getItem() == Items.AIR) break;
            entryBuilder.addSpotlightPage(stack).setLinkRecipe(Boolean.valueOf(true)).setText(this.prefix("drop." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".info")).build();
        }
        return entryBuilder.build();
    }

    private CategoryBuilder addLockedMobEntry(CategoryBuilder builder, String category, RegHelper mobReg, float scale, float offset, ItemStack ... drops) {
        return this.addLockedMobEntry(builder, category, mobReg, false, scale, offset, drops);
    }

    private CategoryBuilder addLockedMobEntry(CategoryBuilder builder, String category, RegHelper mobReg, float scale, float offset, Item ... drops) {
        return this.addLockedMobEntry(builder, category, mobReg, false, scale, offset, Arrays.stream(drops).map(item -> new ItemStack((ItemLike)item)).toList().toArray(new ItemStack[0]));
    }

    private CategoryBuilder addExtendedLockedMobEntry(CategoryBuilder builder, String category, RegHelper mobReg, float scale, float offset, Item ... drops) {
        return this.addLockedMobEntry(builder, category, mobReg, true, scale, offset, Arrays.stream(drops).map(item -> new ItemStack((ItemLike)item)).toList().toArray(new ItemStack[0]));
    }

    private String prefix(String name) {
        return "info.grimoireofgaia.book." + name;
    }

    public RegHelper generateHelper(MobReg<? extends LivingEntity> mobReg) {
        return new RegHelper(mobReg.getName(), mobReg.getSpawnEgg(), mobReg.getEntityType());
    }

    public RegHelper generateHelper(PropReg<? extends LivingEntity> propReg) {
        return new RegHelper(propReg.getName(), propReg.getSpawnEgg(), propReg.getEntityType());
    }

    record RegHelper(String name, DeferredItem<Item> spawnEgg, EntityType<?> entityType) {
    }
}

