/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import gaia.client.model.GelatinousSlimeModel;
import gaia.entity.GelatinousSlime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SlimeItemLayer
extends RenderLayer<GelatinousSlime, GelatinousSlimeModel> {
    public SlimeItemLayer(RenderLayerParent<GelatinousSlime, GelatinousSlimeModel> layerParent) {
        super(layerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, GelatinousSlime gelatinousSlime, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack;
        if (gelatinousSlime.isAlive() && !gelatinousSlime.isInvisible() && !(stack = gelatinousSlime.getOffhandItem()).isEmpty() && !stack.isEmpty()) {
            poseStack.pushPose();
            ((GelatinousSlimeModel)this.getParentModel()).translateToHand(HumanoidArm.LEFT, poseStack);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(-0.0625, 0.125, -0.625);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, packedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, (Level)Minecraft.getInstance().level, (int)gelatinousSlime.blockPosition().asLong());
            poseStack.popPose();
        }
    }
}

