/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.client.ClientHandler;
import gaia.client.model.GelatinousSlimeModel;
import gaia.entity.GelatinousSlime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class GelatinousSlimeLayer
extends RenderLayer<GelatinousSlime, GelatinousSlimeModel> {
    private static final ResourceLocation SLIME_LAYER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"textures/entity/gelatinous_slime/layer_gelatinous_slime.png");
    private final EntityModel<GelatinousSlime> model;

    public GelatinousSlimeLayer(RenderLayerParent<GelatinousSlime, GelatinousSlimeModel> layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.model = new SlimeModel(modelSet.bakeLayer(ClientHandler.GELATINOUS_SLIME));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, GelatinousSlime gelatinousSlime, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = flag = minecraft.shouldEntityAppearGlowing((Entity)gelatinousSlime) && gelatinousSlime.isInvisible();
        if (!gelatinousSlime.isInvisible() || flag) {
            VertexConsumer vertexconsumer = flag ? bufferSource.getBuffer(RenderType.outline((ResourceLocation)this.getTextureLocation(gelatinousSlime))) : bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(gelatinousSlime)));
            ((GelatinousSlimeModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((Entity)gelatinousSlime, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim((Entity)gelatinousSlime, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)gelatinousSlime, (float)0.0f));
        }
    }

    protected ResourceLocation getTextureLocation(GelatinousSlime gelatinousSlime) {
        return SLIME_LAYER_LOCATION;
    }
}

