/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import gaia.client.ClientHandler;
import gaia.client.model.CobblestoneGolemModel;
import gaia.entity.CobblestoneGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CobblestoneGolemRenderer
extends MobRenderer<CobblestoneGolem, CobblestoneGolemModel> {
    public static final ResourceLocation[] COBBLESTONE_GOLEM_LOCATIONS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"textures/entity/cobblestone_golem/cobblestone_golem.png")};

    public CobblestoneGolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CobblestoneGolemModel(context.bakeLayer(ClientHandler.COBBLESTONE_GOLEM)), 0.4f);
    }

    protected void setupRotations(CobblestoneGolem cobblestoneGolem, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)cobblestoneGolem, poseStack, bob, yBodyRot, partialTick, scale);
        if (!((double)cobblestoneGolem.walkAnimation.speed() < 0.01)) {
            float f = 13.0f;
            float f1 = cobblestoneGolem.walkAnimation.position() - cobblestoneGolem.walkAnimation.speed() * (1.0f - partialTick) + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(6.5f * f2));
        }
    }

    public ResourceLocation getTextureLocation(CobblestoneGolem cobbleGolem) {
        return COBBLESTONE_GOLEM_LOCATIONS[cobbleGolem.getVariant()];
    }
}

