/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import gaia.client.ClientHandler;
import gaia.client.model.CobbleGolemModel;
import gaia.entity.CobbleGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CobbleGolemRenderer
extends MobRenderer<CobbleGolem, CobbleGolemModel> {
    public static final ResourceLocation[] COBBLE_GOLEM_LOCATIONS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"textures/entity/cobble_golem/cobble_golem.png")};

    public CobbleGolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CobbleGolemModel(context.bakeLayer(ClientHandler.COBBLE_GOLEM)), 0.4f);
    }

    protected void setupRotations(CobbleGolem cobbleGolem, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)cobbleGolem, poseStack, bob, yBodyRot, partialTick, scale);
        if (!((double)cobbleGolem.walkAnimation.speed() < 0.01)) {
            float f = 13.0f;
            float f1 = cobbleGolem.walkAnimation.position() - cobbleGolem.walkAnimation.speed() * (1.0f - partialTick) + 6.0f;
            float f2 = (Math.abs(f1 % f - 6.5f) - 3.25f) / 3.25f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(6.5f * f2));
        }
    }

    public ResourceLocation getTextureLocation(CobbleGolem cobbleGolem) {
        return COBBLE_GOLEM_LOCATIONS[cobbleGolem.getVariant()];
    }
}

