/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import gaia.config.GaiaConfig;
import gaia.entity.Witch;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class WitchModel
extends EntityModel<Witch>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart broom;
    private final ModelPart bodybottom;
    private final ModelPart bodymiddle;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart hat1;
    private final ModelPart hat3;
    private final ModelPart hat4;
    private final ModelPart hat5;
    private final ModelPart hat6;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;
    private final ModelPart leftleglower;
    private final ModelPart rightleglower;
    private float xRot = 0.0f;
    private float offset = 0.0f;

    public WitchModel(ModelPart root) {
        this.root = root.getChild("witch");
        this.broom = this.root.getChild("broom");
        this.bodybottom = this.root.getChild("bodybottom");
        this.bodymiddle = this.bodybottom.getChild("bodymiddle");
        this.bodytop = this.bodymiddle.getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.hat1 = this.head.getChild("hat1");
        this.hat3 = this.hat1.getChild("hat2").getChild("hat3");
        this.hat4 = this.hat3.getChild("hat4");
        this.hat5 = this.hat4.getChild("hat5");
        this.hat6 = this.hat5.getChild("hat6");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
        this.leftleglower = this.leftleg.getChild("leftleglower");
        this.rightleglower = this.rightleg.getChild("rightleglower");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition witch = partdefinition.addOrReplaceChild("witch", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = witch.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)-13.5f, (float)0.5f));
        PartDefinition skirt1 = bodybottom.addOrReplaceChild("skirt1", CubeListBuilder.create().texOffs(92, 21).addBox(-3.5f, 0.5f, -3.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition skirt2 = skirt1.addOrReplaceChild("skirt2", CubeListBuilder.create().texOffs(92, 29).addBox(-4.0f, -1.0f, -3.5f, 8.0f, 4.0f, 7.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)1.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition amulet = bodytop.addOrReplaceChild("amulet", CubeListBuilder.create().texOffs(36, 55).addBox(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition mantle = bodytop.addOrReplaceChild("mantle", CubeListBuilder.create().texOffs(92, 8).addBox(-4.5f, 0.5f, 0.0f, 9.0f, 10.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)-1.5f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.5f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat1 = head.addOrReplaceChild("hat1", CubeListBuilder.create().texOffs(36, 14).addBox(-7.0f, -1.0f, -7.0f, 14.0f, 2.0f, 14.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition hat2 = hat1.addOrReplaceChild("hat2", CubeListBuilder.create().texOffs(36, 30).addBox(-4.0f, -5.0f, 0.0f, 8.0f, 5.0f, 8.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)-4.0f));
        PartDefinition hat3 = hat2.addOrReplaceChild("hat3", CubeListBuilder.create().texOffs(68, 30).addBox(-6.0f, -6.0f, 0.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)3.0f, (float)-5.0f, (float)1.0f));
        PartDefinition hat4 = hat3.addOrReplaceChild("hat4", CubeListBuilder.create().texOffs(36, 43).addBox(-4.0f, -4.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)-1.0f, (float)-6.0f, (float)1.0f));
        PartDefinition hat5 = hat4.addOrReplaceChild("hat5", CubeListBuilder.create().texOffs(52, 43).addBox(-3.0f, -3.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-0.5f, (float)-4.0f, (float)0.5f));
        PartDefinition hat6 = hat5.addOrReplaceChild("hat6", CubeListBuilder.create().texOffs(36, 51).addBox(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)-0.5f, (float)-3.0f, (float)0.5f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).texOffs(92, 0).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)-2.5f, (float)-4.5f, (float)-1.5f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false).texOffs(92, 0).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f).mirror(false), PartPose.offset((float)2.5f, (float)-4.5f, (float)-1.5f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).mirror().addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition rightleg = witch.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 22).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)-2.0f, (float)-13.0f, (float)0.5f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(24, 32).addBox(-1.505f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).texOffs(92, 40).addBox(-2.005f, 3.0f, -0.5f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition leftleg = witch.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f).mirror(false), PartPose.offset((float)2.0f, (float)-13.0f, (float)0.5f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(24, 32).mirror().addBox(-1.495f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).mirror(false).texOffs(92, 40).mirror().addBox(-1.995f, 3.0f, -0.5f, 4.0f, 4.0f, 4.0f).mirror(false), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition broom = witch.addOrReplaceChild("broom", CubeListBuilder.create().texOffs(112, 43).addBox(-0.5f, -11.0f, -0.5f, 1.0f, 20.0f, 1.0f).texOffs(116, 43).addBox(-1.5f, 8.0f, -1.5f, 3.0f, 10.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Witch witch, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)witch, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !witch.isBaby();
        this.hat1.zRot = -0.5235988f;
        this.hat3.xRot = -0.34906584f;
        this.hat3.zRot = 0.34906584f;
        this.hat4.xRot = -0.34906584f;
        this.hat4.zRot = 0.34906584f;
        this.hat5.xRot = -0.34906584f;
        this.hat5.zRot = 0.34906584f;
        this.hat6.xRot = 0.17453292f;
        this.hat6.zRot = -0.17453292f;
    }

    public void setupAnim(Witch witch, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float leftArmAngleMoving;
        float rightArmAngleMoving;
        boolean moveExtremities;
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.root.y = 24.0f;
        float defaultAngle = 0.0f;
        if (witch.isRidingBroom()) {
            moveExtremities = false;
            rightArmAngleMoving = 0.5235988f;
            leftArmAngleMoving = 0.7853982f;
            this.rightarm.xRot = -rightArmAngleMoving;
            this.rightarm.yRot = -rightArmAngleMoving;
            this.rightarm.zRot = 0.0f;
            this.leftarm.xRot = -leftArmAngleMoving;
            this.leftarm.yRot = leftArmAngleMoving;
            this.leftarm.zRot = 0.0f;
            this.bodytop.xRot = 0.43633232f;
            this.bodymiddle.xRot = 0.17453292f;
            this.bodybottom.xRot = 0.2617994f;
            this.rightleg.xRot = -1.3962634f;
            this.rightleg.yRot = -0.08726646f;
            this.leftleg.xRot = -1.0471976f;
            this.leftleg.yRot = 0.08726646f;
            this.rightleglower.xRot = 0.7853982f;
            this.leftleglower.xRot = 1.3089969f;
            this.broom.visible = true;
            this.xRot = Mth.cos((float)(0.10471976f * ageInTicks)) * 0.1f;
            this.root.xRot = this.xRot - 0.3f;
            this.offset = Mth.cos((float)(ageInTicks * 0.18f)) * 0.9f;
            this.root.y = 24.0f - this.offset;
        } else {
            moveExtremities = true;
            rightArmAngleMoving = defaultAngle;
            leftArmAngleMoving = defaultAngle;
            this.rightarm.xRot = defaultAngle;
            this.rightarm.yRot = defaultAngle;
            this.leftarm.xRot = defaultAngle;
            this.leftarm.yRot = defaultAngle;
            this.bodytop.xRot = defaultAngle;
            this.bodymiddle.xRot = defaultAngle;
            this.bodybottom.xRot = defaultAngle;
            this.rightleg.xRot = defaultAngle;
            this.rightleg.yRot = defaultAngle;
            this.rightleg.zRot = defaultAngle;
            this.leftleg.xRot = defaultAngle;
            this.leftleg.yRot = defaultAngle;
            this.leftleg.zRot = defaultAngle;
            this.rightleglower.xRot = defaultAngle;
            this.leftleglower.xRot = defaultAngle;
            this.broom.visible = false;
            this.xRot = 0.0f;
            this.root.xRot = 0.0f;
        }
        if (moveExtremities) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        }
        if (!moveExtremities) {
            this.rightarm.xRot = -rightArmAngleMoving;
            this.leftarm.xRot = -leftArmAngleMoving;
        }
        if (moveExtremities) {
            this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
            this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        }
        if (this.riding && !witch.isRidingBroom()) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, 0.25);
        poseStack.mulPose(Axis.XP.rotation(this.xRot));
        poseStack.translate(0.0f, -this.offset * 0.0725f, 0.0f);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

