/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Sporeling;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SporelingModel
extends EntityModel<Sporeling>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart headalt;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public SporelingModel(ModelPart root) {
        this.root = root.getChild("sporeling");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.headalt = this.body.getChild("headalt");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition sporeling = partdefinition.addOrReplaceChild("sporeling", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = sporeling.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 0).addBox(-2.0f, -5.0f, -2.0f, 4.0f, 7.0f, 4.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -4.0f, 8.0f, 6.0f, 8.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition headalt = body.addOrReplaceChild("headalt", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -5.0f, -4.0f, 8.0f, 3.0f, 8.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition rightleg = sporeling.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(32, 11).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-1.5f, (float)-3.0f, (float)0.0f));
        PartDefinition leftleg = sporeling.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(32, 11).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)1.5f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Sporeling sporeling, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)sporeling, limbSwing, limbSwingAmount, partialTick);
        this.head.visible = sporeling.getVariant() == 0;
        this.headalt.visible = sporeling.getVariant() == 1;
    }

    public void setupAnim(Sporeling entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.headalt.yRot = netHeadYaw / 57.295776f;
        if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.body.xRot - 0.7f) * 0.75f;
        this.body.xRot -= (float)((double)this.body.xRot - ((double)f7 * 1.2 + (double)f8));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

