/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Sharko;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class SharkoModel
extends EntityModel<Sharko>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart bodyfront;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tailend;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public SharkoModel(ModelPart root) {
        this.root = root.getChild("sharko");
        ModelPart waist = this.root.getChild("waist");
        ModelPart bodyback = waist.getChild("bodymid").getChild("bodyback");
        this.head = bodyback.getChild("head");
        this.bodyfront = bodyback.getChild("bodyfront");
        this.leftarm = bodyback.getChild("leftarm");
        this.rightarm = bodyback.getChild("rightarm");
        this.tail1 = waist.getChild("tail1");
        this.tail2 = this.tail1.getChild("tail2");
        this.tail3 = this.tail2.getChild("tail3");
        this.tailend = this.tail3.getChild("tailend");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition sharko = partdefinition.addOrReplaceChild("sharko", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition waist = sharko.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(32, 35).addBox(-5.0f, 10.0f, 3.0f, 6.0f, 4.0f, 5.0f), PartPose.offset((float)2.0f, (float)-25.0f, (float)-3.5f));
        PartDefinition bodymid = waist.addOrReplaceChild("bodymid", CubeListBuilder.create().texOffs(32, 24).addBox(-4.0f, -5.0f, -5.5f, 8.0f, 5.0f, 6.0f), PartPose.offsetAndRotation((float)-2.0f, (float)10.0f, (float)8.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodyback = bodymid.addOrReplaceChild("bodyback", CubeListBuilder.create().texOffs(32, 12).addBox(-7.0f, -8.0f, -4.0f, 14.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition bodyfront = bodyback.addOrReplaceChild("bodyfront", CubeListBuilder.create().texOffs(32, 0).addBox(-6.0f, -28.0f, -2.0f, 12.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)21.0f, (float)-5.0f));
        PartDefinition rightarm = bodyback.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(68, 10).addBox(-3.0f, -2.0f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offset((float)-7.0f, (float)-2.0f, (float)-3.5f));
        PartDefinition rightpauldron_r1 = rightarm.addOrReplaceChild("rightpauldron_r1", CubeListBuilder.create().texOffs(68, 0).addBox(-6.0f, -1.0f, -2.5f, 7.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)1.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(68, 33).addBox(-2.0f, 0.0f, -3.5f, 4.0f, 10.0f, 4.0f).texOffs(68, 21).addBox(-0.5f, -4.0f, -1.5f, 1.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)-1.5f, (float)6.0f, (float)1.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = bodyback.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(68, 10).mirror().addBox(0.0f, -2.0f, -1.5f, 3.0f, 8.0f, 3.0f).mirror(false), PartPose.offset((float)7.0f, (float)-2.0f, (float)-3.5f));
        PartDefinition leftpauldron_r1 = leftarm.addOrReplaceChild("leftpauldron_r1", CubeListBuilder.create().texOffs(68, 0).mirror().addBox(-1.0f, -1.0f, -2.5f, 7.0f, 5.0f, 5.0f).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(68, 33).mirror().addBox(-2.0f, 0.0f, -3.5f, 4.0f, 10.0f, 4.0f).mirror(false).texOffs(68, 21).addBox(-0.5f, -4.0f, -1.5f, 1.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)1.5f, (float)6.0f, (float)1.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition head = bodyback.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -3.0f, 8.0f, 7.0f, 8.0f).texOffs(0, 43).addBox(-3.0f, 0.0f, -6.0f, 6.0f, 4.0f, 5.0f).texOffs(0, 15).addBox(0.0f, -9.5f, -3.0f, 0.0f, 8.0f, 10.0f), PartPose.offset((float)0.0f, (float)-4.5f, (float)-7.0f));
        PartDefinition headsnout_r1 = head.addOrReplaceChild("headsnout_r1", CubeListBuilder.create().texOffs(0, 33).addBox(-3.5f, 0.0f, -6.0f, 7.0f, 4.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-3.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = waist.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(32, 44).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)-2.0f, (float)11.0f, (float)8.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(48, 44).addBox(-1.5f, 0.5f, -3.0f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(32, 52).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tailend = tail3.addOrReplaceChild("tailend", CubeListBuilder.create().texOffs(40, 52).addBox(-7.0f, 22.0f, -4.5f, 10.0f, 6.0f, 1.0f), PartPose.offset((float)2.0f, (float)-20.0f, (float)3.0f));
        PartDefinition rightleg = sharko.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(100, 10).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-13.0f, (float)2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(100, 21).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightfoot = rightleglower.addOrReplaceChild("rightfoot", CubeListBuilder.create().texOffs(100, 27).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)3.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = sharko.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(100, 10).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f), PartPose.offsetAndRotation((float)3.0f, (float)-13.0f, (float)2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(100, 21).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftfoot = leftleglower.addOrReplaceChild("leftfoot", CubeListBuilder.create().texOffs(100, 27).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)3.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Sharko sharko, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)sharko, limbSwing, limbSwingAmount, partialTick);
    }

    public void setupAnim(Sharko sharko, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        if (sharko.getAnimationState() == 0) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.2617994f;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f + 0.17453292f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.2617994f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f - 0.17453292f;
        } else {
            this.animationBuff();
        }
        this.tail1.yRot = Mth.cos((float)((float)Math.PI / 180 * (ageInTicks * 7.0f))) * ((float)Math.PI / 90);
        this.tail2.yRot = Mth.cos((float)((float)Math.PI / 180 * (ageInTicks * 7.0f))) * 0.06981317f;
        this.tailend.yRot = this.tail3.yRot = Mth.cos((float)((float)Math.PI / 180 * (ageInTicks * 7.0f))) * 0.10471976f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.rightleg.xRot -= 0.5585054f;
        this.leftleg.xRot -= 0.5585054f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.yRot += this.bodyfront.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        this.leftarm.xRot = (float)((double)this.leftarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.leftarm.yRot += this.bodyfront.yRot * 2.0f;
        this.leftarm.zRot -= Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationBuff() {
        this.rightarm.xRot = 0.0f;
        this.leftarm.xRot = 0.0f;
        this.rightarm.zRot = 0.785398f;
        this.leftarm.zRot = -0.785398f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.0625, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

