/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Orc;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class OrcModel
extends EntityModel<Orc>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public OrcModel(ModelPart root) {
        this.root = root.getChild("orc");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.leftarm = this.body.getChild("leftarm");
        this.rightarm = this.body.getChild("rightarm");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition orc = partdefinition.addOrReplaceChild("orc", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = orc.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, 0.0f, -2.0f, 10.0f, 14.0f, 4.0f).texOffs(0, 34).addBox(-5.0f, 0.0f, -2.0f, 10.0f, 14.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(64, 39).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)-26.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f).texOffs(64, 0).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftear_r1 = head.addOrReplaceChild("leftear_r1", CubeListBuilder.create().texOffs(64, -5).addBox(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 5.0f), PartPose.offsetAndRotation((float)4.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition rightear_r1 = head.addOrReplaceChild("rightear_r1", CubeListBuilder.create().texOffs(64, -5).addBox(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 5.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-3.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition headjaw = head.addOrReplaceChild("headjaw", CubeListBuilder.create().texOffs(64, 18).addBox(-4.5f, -0.5f, -4.0f, 9.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.5f));
        PartDefinition righthorn = head.addOrReplaceChild("righthorn", CubeListBuilder.create().texOffs(64, 25).addBox(-5.5f, -8.5f, -2.5f, 2.0f, 2.0f, 2.0f).texOffs(64, 29).addBox(-6.5f, -10.5f, -1.5f, 3.0f, 3.0f, 3.0f).texOffs(64, 35).addBox(-4.5f, -11.5f, -2.5f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lefthorn = head.addOrReplaceChild("lefthorn", CubeListBuilder.create().texOffs(64, 25).addBox(3.5f, -8.5f, -2.5f, 2.0f, 2.0f, 2.0f).texOffs(64, 29).addBox(3.5f, -10.5f, -1.5f, 3.0f, 3.0f, 3.0f).texOffs(64, 35).addBox(2.5f, -11.5f, -2.5f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(28, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f).texOffs(100, 26).addBox(-4.5f, -3.5f, -1.5f, 3.0f, 3.0f, 3.0f).texOffs(100, 10).addBox(-3.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f).texOffs(100, 32).addBox(-3.5f, 7.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)-6.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftarm = body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(28, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f).mirror(false).texOffs(100, 0).mirror().addBox(-1.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false).texOffs(100, 20).mirror().addBox(1.5f, -3.5f, -1.5f, 3.0f, 3.0f, 3.0f).mirror(false).texOffs(100, 32).mirror().addBox(-1.5f, 7.5f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false), PartPose.offset((float)6.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightleg = orc.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(44, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).texOffs(100, 42).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f).texOffs(100, 52).addBox(-2.5f, 7.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftleg = orc.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(44, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).mirror(false).texOffs(100, 42).mirror().addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false).texOffs(100, 52).mirror().addBox(-2.5f, 7.0f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Orc orc, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        int animationState = orc.getAnimationState();
        if (animationState == 0) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        } else if (animationState == 1) {
            this.animationThrow();
        } else if (animationState == 2) {
            this.animationBuff();
        }
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.body.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        this.rightarm.xRot = -1.0472f;
    }

    private void animationBuff() {
        this.rightarm.xRot = 0.0f;
        this.leftarm.xRot = 0.0f;
        this.rightarm.zRot = 0.785398f;
        this.leftarm.zRot = -0.785398f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

