/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Oni;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class OniModel
extends EntityModel<Oni>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public OniModel(ModelPart root) {
        this.root = root.getChild("oni");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition oni = partdefinition.addOrReplaceChild("oni", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = oni.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f).texOffs(88, 0).addBox(-3.5f, -2.0f, -2.0f, 7.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -3.0f, -2.05f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.5f, -2.15f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)1.05f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)-0.05f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lefthorn_r1 = head.addOrReplaceChild("lefthorn_r1", CubeListBuilder.create().texOffs(36, 14).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)2.0f, (float)-5.5f, (float)-2.0f, (float)0.5236f, (float)0.0f, (float)-0.1745f));
        PartDefinition righthorn_r1 = head.addOrReplaceChild("righthorn_r1", CubeListBuilder.create().texOffs(36, 14).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-5.5f, (float)-2.0f, (float)0.5236f, (float)0.0f, (float)0.1745f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 36).addBox(-3.0f, -1.0f, -1.5f, 3.0f, 6.0f, 3.0f).texOffs(64, 0).addBox(-3.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 45).addBox(-5.505f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)2.5f, (float)5.0f, (float)1.5f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.5f, 3.0f, 6.0f, 3.0f).mirror(false).texOffs(64, 0).mirror().addBox(-0.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 21).mirror().addBox(-1.495f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f).mirror(false), PartPose.offset((float)1.5f, (float)5.0f, (float)1.5f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition sake = bodytop.addOrReplaceChild("sake", CubeListBuilder.create().texOffs(64, 8).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 6.0f).texOffs(64, 20).addBox(-2.0f, -7.0f, 1.0f, 4.0f, 4.0f, 4.0f).texOffs(64, 28).addBox(-1.0f, -8.0f, 2.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)-0.5f, (float)-2.0f, (float)0.5f));
        PartDefinition sakerope = sake.addOrReplaceChild("sakerope", CubeListBuilder.create().texOffs(64, 32).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)2.5f, (float)1.0f, (float)5.5f));
        PartDefinition rightleg = oni.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(88, 17).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f).texOffs(88, 8).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f), PartPose.offset((float)-2.0f, (float)-13.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(88, 24).addBox(-1.505f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition leftleg = oni.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(88, 17).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f).texOffs(88, 8).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f).mirror(false), PartPose.offset((float)2.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(88, 24).addBox(-1.495f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Oni oni, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)oni, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !oni.isBaby();
    }

    public void setupAnim(Oni oni, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        if (oni.isBuffed()) {
            this.animationBuff();
        } else {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            float armDefaultAngleZ = 0.1745329f;
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + armDefaultAngleZ;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + armDefaultAngleZ;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        }
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationBuff() {
        this.rightarm.xRot = 0.0f;
        this.leftarm.xRot = 0.0f;
        this.rightarm.zRot = 0.785398f;
        this.leftarm.zRot = -0.785398f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

