/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Mimic;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MimicModel
extends EntityModel<Mimic> {
    private final ModelPart root;
    private final ModelPart top;
    private final ModelPart bottom;

    public MimicModel(ModelPart root) {
        this.root = root.getChild("mimic");
        this.top = this.root.getChild("top");
        this.bottom = this.root.getChild("bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition mimic = partdefinition.addOrReplaceChild("mimic", CubeListBuilder.create().texOffs(56, 40).addBox(-5.0f, -26.0f, -4.0f, 10.0f, 14.0f, 10.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition top = mimic.addOrReplaceChild("top", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-19.0f, (float)7.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        top.addOrReplaceChild("lid1", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -24.0f, -7.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-7.0f));
        top.addOrReplaceChild("teeth1", CubeListBuilder.create().texOffs(56, 0).addBox(-6.0f, -22.0f, -6.0f, 12.0f, 8.0f, 12.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-7.0f));
        top.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -21.0f, -8.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-7.0f));
        PartDefinition bottom = mimic.addOrReplaceChild("bottom", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-19.0f, (float)7.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        bottom.addOrReplaceChild("lid2", CubeListBuilder.create().texOffs(0, 19).addBox(-7.0f, -19.0f, -7.0f, 14.0f, 10.0f, 14.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-7.0f));
        bottom.addOrReplaceChild("teeth2", CubeListBuilder.create().texOffs(56, 20).addBox(-6.0f, -23.0f, -6.0f, 12.0f, 8.0f, 12.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Mimic entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.top.xRot = Mth.cos((float)(ageInTicks * 1.8f + (float)Math.PI)) * 0.8f * 0.5f;
        this.bottom.xRot = Mth.cos((float)(ageInTicks * 1.8f)) * 0.8f * 0.5f;
        this.top.xRot -= 0.69813174f;
        this.bottom.xRot += 0.3490659f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

