/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Kobold;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;

public class KoboldModel
extends EntityModel<Kobold>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart rightear01;
    private final ModelPart leftear01;
    private final ModelPart rightear02;
    private final ModelPart leftear02;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public KoboldModel(ModelPart root) {
        this.root = root.getChild("kobold");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        this.head = this.bodytop.getChild("neck").getChild("head");
        this.rightear01 = this.head.getChild("rightear01");
        this.leftear01 = this.head.getChild("leftear01");
        this.rightear02 = this.head.getChild("rightear02");
        this.leftear02 = this.head.getChild("leftear02");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.tail1 = bodybottom.getChild("tail1");
        this.tail2 = this.tail1.getChild("tail2");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition kobold = partdefinition.addOrReplaceChild("kobold", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = kobold.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f).texOffs(76, 7).addBox(-3.5f, -2.0f, -2.0f, 7.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -1.5f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -1.6f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headaccessory = head.addOrReplaceChild("headaccessory", CubeListBuilder.create().texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightear01 = head.addOrReplaceChild("rightear01", CubeListBuilder.create().texOffs(36, 26).addBox(0.0f, 0.0f, -4.0f, 3.0f, 3.0f, 4.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)3.0f, (float)-0.7854f, (float)0.7854f, (float)0.0f));
        PartDefinition leftear01 = head.addOrReplaceChild("leftear01", CubeListBuilder.create().texOffs(36, 26).mirror().addBox(-3.0f, 0.0f, -4.0f, 3.0f, 3.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-6.0f, (float)3.0f, (float)-0.7854f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightear02 = head.addOrReplaceChild("rightear02", CubeListBuilder.create().texOffs(36, 33).addBox(-1.5f, -7.0f, -5.5f, 3.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leftear02 = head.addOrReplaceChild("leftear02", CubeListBuilder.create().texOffs(36, 33).addBox(-1.5f, -7.0f, -5.5f, 3.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition headsnout = head.addOrReplaceChild("headsnout", CubeListBuilder.create().texOffs(36, 22).addBox(-1.5f, -2.0f, -2.5f, 3.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition hair = head.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(36, 14).addBox(-4.0f, -2.5f, 0.0f, 8.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightcheek = head.addOrReplaceChild("rightcheek", CubeListBuilder.create().texOffs(46, 22).addBox(-2.0f, -0.5f, 0.0f, 2.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-1.5f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition rightcheek03_r1 = rightcheek.addOrReplaceChild("rightcheek03_r1", CubeListBuilder.create().texOffs(47, 23).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition rightcheek01_r1 = rightcheek.addOrReplaceChild("rightcheek01_r1", CubeListBuilder.create().texOffs(47, 23).addBox(-1.0f, -1.0f, 0.25f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition leftcheek = head.addOrReplaceChild("leftcheek", CubeListBuilder.create().texOffs(46, 22).mirror().addBox(0.0f, -0.5f, 0.0f, 2.0f, 1.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-1.5f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition leftcheek03_r1 = leftcheek.addOrReplaceChild("leftcheek03_r1", CubeListBuilder.create().texOffs(47, 23).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition leftcheek01_r1 = leftcheek.addOrReplaceChild("leftcheek01_r1", CubeListBuilder.create().texOffs(47, 23).addBox(0.0f, -1.0f, 0.25f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(0.25f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).addBox(-2.25f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(64, 0).addBox(-1.5f, -3.0f, -2.5f, 2.0f, 6.0f, 3.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition righthand = rightarmlower.addOrReplaceChild("righthand", CubeListBuilder.create().texOffs(64, 11).addBox(0.0f, 0.0f, -2.0f, 2.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)-1.5f, (float)3.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-0.5f, -3.0f, -2.5f, 2.0f, 6.0f, 3.0f).mirror(false), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition lefthand = leftarmlower.addOrReplaceChild("lefthand", CubeListBuilder.create().texOffs(64, 11).mirror().addBox(-2.0f, 0.0f, -2.0f, 2.0f, 4.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)3.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition backpack = bodybottom.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(76, 0).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)1.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = bodybottom.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(76, 15).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(76, 22).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = kobold.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(98, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)2.5f, (float)-12.5f, (float)0.5f, (float)-0.3491f, (float)0.0873f, (float)0.0436f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(98, 11).addBox(-1.495f, 0.0f, 0.0f, 3.0f, 8.0f, 2.0f), PartPose.offset((float)0.0f, (float)3.5f, (float)1.5f));
        PartDefinition leftlegfoot = leftleglower.addOrReplaceChild("leftlegfoot", CubeListBuilder.create().texOffs(98, 21).addBox(-1.495f, 0.0f, -3.0f, 3.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = kobold.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(98, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-12.5f, (float)0.5f, (float)-0.3491f, (float)-0.0873f, (float)-0.0436f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(98, 11).addBox(-1.505f, 0.0f, 0.0f, 3.0f, 8.0f, 2.0f), PartPose.offset((float)0.0f, (float)3.5f, (float)1.5f));
        PartDefinition rightlegfoot = rightleglower.addOrReplaceChild("rightlegfoot", CubeListBuilder.create().texOffs(98, 21).addBox(-1.505f, 0.0f, -3.0f, 3.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Kobold kobold, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)kobold, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !kobold.isBaby();
    }

    public void setupAnim(Kobold kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        float earDefaultAngleX = -0.7853982f;
        this.rightear01.xRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.06981317f;
        this.rightear01.xRot += earDefaultAngleX;
        this.leftear01.xRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.06981317f;
        this.leftear01.xRot += earDefaultAngleX;
        float earDefaultAngleZ = 0.7853982f;
        this.rightear02.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.06981317f;
        this.rightear02.yRot += earDefaultAngleZ;
        this.leftear02.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * -0.06981317f;
        this.leftear02.yRot -= earDefaultAngleZ;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        if (kobold.isAggressive() && kobold.getMainHandItem().getItem() instanceof BowItem) {
            this.holdingBow(ageInTicks);
        } else if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.tail1.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.2617994f;
        this.tail2.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.34906584f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.rightleg.xRot -= 0.3490659f;
        this.leftleg.xRot -= 0.3490659f;
        this.rightleg.yRot = -0.0872665f;
        this.leftleg.yRot = 0.0872665f;
        this.rightleg.zRot = -0.0349066f;
        this.leftleg.zRot = 0.0349066f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    private void holdingBow(float ageInTicks) {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        float f1 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
        this.rightarm.zRot = -0.3f;
        this.leftarm.zRot = 0.3f;
        this.rightarm.yRot = -(0.1f - f * 0.6f);
        this.leftarm.yRot = 0.3f - f * 0.6f;
        this.rightarm.xRot = -1.5707964f;
        this.leftarm.xRot = -1.5707964f;
        this.rightarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.leftarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.0625, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

