/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.AbstractGaiaEntity;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;

public class GoblinModel<T extends AbstractGaiaEntity>
extends EntityModel<T>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public GoblinModel(ModelPart root) {
        this.root = root.getChild("goblin");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.leftarm = this.body.getChild("leftarm");
        this.rightarm = this.body.getChild("rightarm");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition goblin = partdefinition.addOrReplaceChild("goblin", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = goblin.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 8.0f, 4.0f).texOffs(64, 30).addBox(-4.0f, 0.0f, 2.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f).texOffs(64, 0).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headnose = head.addOrReplaceChild("headnose", CubeListBuilder.create().texOffs(64, 24).addBox(-1.0f, -3.0f, -7.0f, 2.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(64, 10).addBox(-5.5f, -7.0f, 0.0f, 0.0f, 6.0f, 8.0f).texOffs(80, 10).addBox(-5.4f, -7.0f, 0.0f, 0.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(64, 10).addBox(5.5f, -7.0f, 0.0f, 0.0f, 6.0f, 8.0f).texOffs(80, 10).addBox(5.4f, -7.0f, 0.0f, 0.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition rightarm = body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(24, 16).addBox(-3.0f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f).texOffs(100, 0).addBox(-3.5f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f).texOffs(100, 8).addBox(-3.5f, 3.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftarm = body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(24, 16).mirror().addBox(0.0f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f).mirror(false).texOffs(100, 0).mirror().addBox(-0.5f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f).mirror(false).texOffs(100, 8).mirror().addBox(-0.5f, 3.0f, -2.0f, 4.0f, 4.0f, 4.0f).mirror(false), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightleg = goblin.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(36, 16).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f).texOffs(100, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f).texOffs(100, 24).addBox(-2.0f, 4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)-2.0f, (float)-8.0f, (float)0.0f));
        PartDefinition leftleg = goblin.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(36, 16).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f).mirror(false).texOffs(100, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f).mirror(false).texOffs(100, 24).addBox(-2.0f, 4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)2.0f, (float)-8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T gaiaEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        if (gaiaEntity.isAggressive() && gaiaEntity.getMainHandItem().getItem() instanceof BowItem) {
            this.holdingBow(ageInTicks);
        } else if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    private void holdingBow(float ageInTicks) {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        float f1 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
        this.rightarm.zRot = -0.3f;
        this.leftarm.zRot = 0.3f;
        this.rightarm.yRot = -(0.1f - f * 0.6f);
        this.leftarm.yRot = 0.3f - f * 0.6f;
        this.rightarm.xRot = -1.5707964f;
        this.leftarm.xRot = -1.5707964f;
        this.rightarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.leftarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.body.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.3125, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

