/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.EnderDragonGirl;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class EnderDragonGirlModel
extends EntityModel<EnderDragonGirl>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;
    private final ModelPart leftwing;
    private final ModelPart rightwing;
    private boolean isCarrying;

    public EnderDragonGirlModel(ModelPart root) {
        this.root = root.getChild("ender_dragon_girl");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.leftwing = this.bodytop.getChild("leftwing");
        this.rightwing = this.bodytop.getChild("rightwing");
        this.tail1 = bodybottom.getChild("tail1");
        this.tail2 = this.tail1.getChild("tail2");
        this.tail3 = this.tail2.getChild("tail3");
        this.leftleg = this.root.getChild("leftleg1");
        this.rightleg = this.root.getChild("rightleg1");
        this.setCarrying(false);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition ender_dragon_girl = partdefinition.addOrReplaceChild("ender_dragon_girl", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = ender_dragon_girl.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f).texOffs(64, 6).addBox(-3.5f, -0.9f, -2.0f, 7.0f, 3.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-18.5f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymid = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymid.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("lefthorn_r1", CubeListBuilder.create().texOffs(36, 14).addBox(-1.0f, -0.5f, 0.0f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)3.0f, (float)-6.0f, (float)-2.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("righthorn_r1", CubeListBuilder.create().texOffs(36, 14).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-5.5f, (float)-2.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(36, 19).addBox(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-2.0f, (float)-2.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(36, 19).mirror().addBox(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-2.0f, (float)-2.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)0.3491f, (float)0.0f, (float)0.3491f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-1.0f, (float)5.0f, (float)1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        rightarmlower.addOrReplaceChild("rightclaw", CubeListBuilder.create().texOffs(64, 0).addBox(-0.005f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-1.0f, (float)6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-1.0f, (float)0.3491f, (float)0.0f, (float)-0.3491f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)1.0f, (float)5.0f, (float)1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        leftarmlower.addOrReplaceChild("leftclaw", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-1.995f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        bodytop.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(104, 34).addBox(0.0f, -4.0f, 0.0f, 0.0f, 18.0f, 12.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-4.0f, (float)-0.5f, (float)0.5236f, (float)-0.5236f, (float)0.0f));
        bodytop.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(104, 34).addBox(0.0f, -4.0f, 0.0f, 0.0f, 18.0f, 12.0f), PartPose.offsetAndRotation((float)2.0f, (float)-4.0f, (float)-0.5f, (float)0.5236f, (float)0.5236f, (float)0.0f));
        PartDefinition tail1 = bodybottom.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(64, 13).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)1.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(64, 24).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(64, 32).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg1 = ender_dragon_girl.addOrReplaceChild("rightleg1", CubeListBuilder.create().texOffs(86, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 11.0f, 3.0f).texOffs(86, 14).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-17.0f, (float)-0.5f, (float)-0.2618f, (float)0.1745f, (float)0.0f));
        PartDefinition rightleg3 = rightleg1.addOrReplaceChild("rightleg3", CubeListBuilder.create().texOffs(86, 26).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)9.5f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg4 = rightleg3.addOrReplaceChild("rightleg4", CubeListBuilder.create().texOffs(86, 33).addBox(-1.5f, -2.0f, -6.0f, 3.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)5.0f, (float)2.0944f, (float)0.0f, (float)0.0f));
        rightleg4.addOrReplaceChild("rightleg5", CubeListBuilder.create().texOffs(86, 41).addBox(-1.5f, -4.0f, -1.0f, 3.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg1 = ender_dragon_girl.addOrReplaceChild("leftleg1", CubeListBuilder.create().texOffs(86, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 11.0f, 3.0f).texOffs(86, 14).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)2.0f, (float)-17.0f, (float)-0.5f, (float)-0.2618f, (float)-0.1745f, (float)0.0f));
        PartDefinition leftleg3 = leftleg1.addOrReplaceChild("leftleg3", CubeListBuilder.create().texOffs(86, 26).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)9.5f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg4 = leftleg3.addOrReplaceChild("leftleg4", CubeListBuilder.create().texOffs(86, 33).addBox(-1.5f, -2.0f, -6.0f, 3.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)5.0f, (float)2.0944f, (float)0.0f, (float)0.0f));
        leftleg4.addOrReplaceChild("leftleg5", CubeListBuilder.create().texOffs(86, 41).addBox(-1.5f, -4.0f, -1.0f, 3.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(EnderDragonGirl enderDragonGirl, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)enderDragonGirl, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !enderDragonGirl.isBaby();
    }

    public void setupAnim(EnderDragonGirl enderDragonGirl, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f + 0.1745329f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        if (this.isCarrying) {
            this.rightarm.xRot -= 0.5f;
            this.leftarm.xRot -= 0.5f;
            this.rightarm.zRot += 0.05f;
            this.leftarm.zRot -= 0.05f;
        } else if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.4363323f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.4363323f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.rightwing.yRot = Mth.cos((float)(ageInTicks * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount * 0.5f;
        this.leftwing.yRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 1.0f * limbSwingAmount * 0.5f;
        this.rightwing.yRot -= 0.5235988f;
        this.leftwing.yRot += 0.5235988f;
        this.tail1.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.05235988f;
        this.tail2.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.10471976f;
        this.tail3.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.15707964f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount * 1.5f;
        this.rightleg.xRot -= 0.3490659f;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6665f + (float)Math.PI)) * 0.5f * limbSwingAmount * 1.5f;
        this.leftleg.xRot -= 0.3490659f;
        this.rightleg.yRot = 0.1745329f;
        this.leftleg.yRot = -0.1745329f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void setCarrying(boolean carrying) {
        this.isCarrying = carrying;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

