/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Dwarf;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class DwarfModel
extends EntityModel<Dwarf>
implements HeadedModel,
ArmedModel {
    private final ModelPart head;
    private final ModelPart headLight;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public DwarfModel(ModelPart root) {
        this.head = root.getChild("head");
        this.headLight = this.head.getChild("headlight");
        this.body = root.getChild("body");
        this.rightarm = root.getChild("rightarm");
        this.leftarm = root.getChild("leftarm");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition headlight = head.addOrReplaceChild("headlight", CubeListBuilder.create().texOffs(64, 44).addBox(-1.5f, -9.0f, -5.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headaccessory = head.addOrReplaceChild("headaccessory", CubeListBuilder.create().texOffs(64, 0).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headbeard = head.addOrReplaceChild("headbeard", CubeListBuilder.create().texOffs(64, 18).addBox(-4.5f, -2.0f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = head.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(64, 36).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 10.0f, 4.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(24, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.offset((float)-5.0f, (float)6.0f, (float)0.0f));
        PartDefinition rightarmpauldron = rightarm.addOrReplaceChild("rightarmpauldron", CubeListBuilder.create().texOffs(100, 0).addBox(-3.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarmgauntlet = rightarm.addOrReplaceChild("rightarmgauntlet", CubeListBuilder.create().texOffs(100, 10).addBox(-3.5f, 3.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(24, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f).mirror(false), PartPose.offset((float)5.0f, (float)6.0f, (float)0.0f));
        PartDefinition leftarmpauldron = leftarm.addOrReplaceChild("leftarmpauldron", CubeListBuilder.create().texOffs(100, 0).mirror().addBox(-1.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftarmgauntlet = leftarm.addOrReplaceChild("leftarmgauntlet", CubeListBuilder.create().texOffs(100, 10).mirror().addBox(-1.5f, 3.5f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.offset((float)-2.0f, (float)14.0f, (float)0.0f));
        PartDefinition rightlegupper = rightleg.addOrReplaceChild("rightlegupper", CubeListBuilder.create().texOffs(100, 20).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegboot = rightleg.addOrReplaceChild("rightlegboot", CubeListBuilder.create().texOffs(100, 30).addBox(-2.5f, 5.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f).mirror(false), PartPose.offset((float)2.0f, (float)14.0f, (float)0.0f));
        PartDefinition leftlegupper = leftleg.addOrReplaceChild("leftlegupper", CubeListBuilder.create().texOffs(100, 20).mirror().addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftlegboot = leftleg.addOrReplaceChild("leftlegboot", CubeListBuilder.create().texOffs(100, 30).mirror().addBox(-2.5f, 5.0f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Dwarf dwarf, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)dwarf, limbSwing, limbSwingAmount, partialTick);
        this.headLight.visible = dwarf.getVariant() == 2;
    }

    public void setupAnim(Dwarf dwarf, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        ItemStack itemstack = dwarf.getMainHandItem();
        if (dwarf.isAggressive() && itemstack.getItem() instanceof BowItem) {
            this.holdingBow(ageInTicks);
        } else if (this.attackTime > -9990.0f) {
            this.holdingMelee();
        }
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.0872665f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.0872665f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    private void holdingBow(float ageInTicks) {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        float f1 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
        this.rightarm.zRot = -0.3f;
        this.leftarm.zRot = 0.3f;
        this.rightarm.yRot = -(0.1f - f * 0.6f);
        this.leftarm.yRot = 0.3f - f * 0.6f;
        this.rightarm.xRot = -1.5707964f;
        this.leftarm.xRot = -1.5707964f;
        this.rightarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.leftarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.body.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

