/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.CobblestoneGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CobblestoneGolemModel
extends EntityModel<CobblestoneGolem> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public CobblestoneGolemModel(ModelPart root) {
        this.root = root.getChild("cobblestone_golem");
        ModelPart body = this.root.getChild("bodymid").getChild("bodylower").getChild("body");
        this.head = body.getChild("head");
        this.rightarm = body.getChild("rightarm");
        this.leftarm = body.getChild("leftarm");
        this.rightleg = this.root.getChild("rightleg");
        this.leftleg = this.root.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition cobblestone_golem = partdefinition.addOrReplaceChild("cobblestone_golem", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)-2.0f));
        PartDefinition bodymid = cobblestone_golem.addOrReplaceChild("bodymid", CubeListBuilder.create().texOffs(0, 61).addBox(-6.5f, 14.0f, 1.0f, 13.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)-31.0f, (float)-2.5f));
        PartDefinition bodylower = bodymid.addOrReplaceChild("bodylower", CubeListBuilder.create().texOffs(0, 45).addBox(-6.0f, -10.0f, -6.0f, 12.0f, 10.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)7.6f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = bodylower.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 26).addBox(-7.0f, -11.0f, -7.0f, 14.0f, 11.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f).texOffs(32, 0).addBox(-2.0f, -10.0f, -9.0f, 4.0f, 4.0f, 1.0f).texOffs(32, 5).addBox(-1.0f, -5.0f, -9.0f, 2.0f, 3.0f, 1.0f).texOffs(32, 9).addBox(-2.0f, -1.0f, -9.0f, 4.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-7.1f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(45, 17).addBox(-4.0f, -1.0f, -2.0f, 5.0f, 11.0f, 5.0f), PartPose.offsetAndRotation((float)-7.0f, (float)-8.5f, (float)-3.5f, (float)-0.5236f, (float)0.2618f, (float)0.0f));
        PartDefinition rightshoulder = rightarm.addOrReplaceChild("rightshoulder", CubeListBuilder.create().texOffs(81, 0).mirror().addBox(-7.0f, -4.0f, -4.5f, 9.0f, 8.0f, 9.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(45, 33).addBox(-2.505f, 0.0f, -5.0f, 5.0f, 11.0f, 5.0f).texOffs(73, 49).mirror().addBox(-3.505f, 2.5f, -6.0f, 7.0f, 9.0f, 7.0f).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)10.0f, (float)3.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(45, 17).addBox(-1.0f, -1.0f, -2.0f, 5.0f, 11.0f, 5.0f), PartPose.offsetAndRotation((float)7.0f, (float)-8.5f, (float)-3.5f, (float)-0.5236f, (float)-0.2618f, (float)0.0f));
        PartDefinition leftshoulder = leftarm.addOrReplaceChild("leftshoulder", CubeListBuilder.create().texOffs(45, 0).mirror().addBox(-2.0f, -4.0f, -4.5f, 9.0f, 8.0f, 9.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(45, 33).addBox(-2.495f, 0.0f, -4.9f, 5.0f, 11.0f, 5.0f).texOffs(45, 49).mirror().addBox(-3.495f, 2.5f, -5.9f, 7.0f, 9.0f, 7.0f).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)10.0f, (float)2.9f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition back = body.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 16).addBox(-6.0f, -5.0f, -5.0f, 12.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = cobblestone_golem.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(45, 65).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.offset((float)-3.0f, (float)-15.0f, (float)2.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(45, 79).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 10.0f, 5.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-1.0f));
        PartDefinition leftleg = cobblestone_golem.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(45, 65).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.offset((float)3.0f, (float)-15.0f, (float)2.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(45, 79).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 10.0f, 5.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void prepareMobModel(CobblestoneGolem cobbleGolem, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)cobbleGolem, limbSwing, limbSwingAmount, partialTick);
        int i = cobbleGolem.getAttackAnimationTick();
        float rotation = 0.0f;
        if (i > 0) {
            this.leftarm.xRot = rotation - 2.0f + 1.5f * Mth.triangleWave((float)((float)i - partialTick), (float)10.0f);
            this.rightarm.xRot = rotation - 2.0f + 1.5f * Mth.triangleWave((float)((float)i - partialTick), (float)10.0f);
        } else {
            this.leftarm.xRot = rotation + (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.rightarm.xRot = rotation + (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public void setupAnim(CobblestoneGolem cobbleGolem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f - 0.2617994f;
        this.leftarm.zRot = 0.0f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f - 0.2617994f;
        this.leftarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f - 0.2617994f;
        this.rightarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightleg.xRot = -1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightleg.xRot -= 0.1745329f;
        this.leftleg.xRot = 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftleg.xRot -= 0.1745329f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

