/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.CobbleGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CobbleGolemModel
extends EntityModel<CobbleGolem> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public CobbleGolemModel(ModelPart root) {
        this.root = root.getChild("cobble_golem");
        ModelPart body = this.root.getChild("bodylower").getChild("body");
        this.head = body.getChild("head");
        this.rightarm = body.getChild("rightarm");
        this.leftarm = body.getChild("leftarm");
        this.rightleg = this.root.getChild("rightleg");
        this.leftleg = this.root.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition cobble_golem = partdefinition.addOrReplaceChild("cobble_golem", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodylower = cobble_golem.addOrReplaceChild("bodylower", CubeListBuilder.create().texOffs(0, 28).addBox(-4.0f, -2.0f, -3.0f, 8.0f, 4.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = bodylower.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 8).addBox(-7.0f, -12.0f, -7.0f, 14.0f, 12.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-7.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(44, 0).addBox(-6.0f, -4.0f, -3.0f, 6.0f, 12.0f, 6.0f).texOffs(44, 18).addBox(-5.0f, 8.0f, -2.0f, 4.0f, 14.0f, 4.0f), PartPose.offsetAndRotation((float)-7.0f, (float)-8.0f, (float)-3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(44, 0).mirror().addBox(0.0f, -4.0f, -3.0f, 6.0f, 12.0f, 6.0f).mirror(false).texOffs(44, 18).addBox(1.0f, 8.0f, -2.0f, 4.0f, 14.0f, 4.0f), PartPose.offsetAndRotation((float)7.0f, (float)-8.0f, (float)-3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = cobble_golem.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(44, 36).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-8.5f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(44, 45).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 6.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)-0.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = cobble_golem.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(44, 36).mirror().addBox(-1.5f, -1.5f, -1.5f, 3.0f, 6.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-8.5f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(44, 45).mirror().addBox(-2.0f, -2.0f, 0.0f, 4.0f, 6.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)-0.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(CobbleGolem cobbleGolem, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)cobbleGolem, limbSwing, limbSwingAmount, partialTick);
        int i = cobbleGolem.getAttackAnimationTick();
        float rotation = -0.2617994f;
        if (i > 0) {
            this.rightarm.xRot = rotation - 2.0f + 1.5f * Mth.triangleWave((float)((float)i - partialTick), (float)10.0f);
            this.leftarm.xRot = rotation - 2.0f + 1.5f * Mth.triangleWave((float)((float)i - partialTick), (float)10.0f);
        } else {
            this.rightarm.xRot = rotation + (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftarm.xRot = rotation + (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public void setupAnim(CobbleGolem cobbleGolem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightleg.xRot = -1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightleg.xRot -= 0.1745329f;
        this.leftleg.xRot = 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftleg.xRot -= 0.1745329f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

