/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Centaur;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.phys.Vec3;

public class CentaurModel
extends EntityModel<Centaur>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart tail;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart leftlegupper;
    private final ModelPart rightlegupper;
    private final ModelPart leftlegback1;
    private final ModelPart rightlegback1;
    private final ModelPart leftlegback2;
    private final ModelPart rightlegback2;
    private final ModelPart leftlegback3;
    private final ModelPart rightlegback3;

    public CentaurModel(ModelPart root) {
        this.root = root.getChild("centaur");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.body1 = this.root.getChild("body1");
        this.leftlegupper = this.body1.getChild("leftlegupper");
        this.rightlegupper = this.body1.getChild("rightlegupper");
        this.body2 = this.body1.getChild("body2");
        this.tail = this.body2.getChild("tail");
        this.leftlegback1 = this.body2.getChild("leftlegback1");
        this.rightlegback1 = this.body2.getChild("rightlegback1");
        this.leftlegback2 = this.leftlegback1.getChild("leftlegback2");
        this.rightlegback2 = this.rightlegback1.getChild("rightlegback2");
        this.leftlegback3 = this.leftlegback2.getChild("leftlegback3");
        this.rightlegback3 = this.rightlegback2.getChild("rightlegback3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition centaur = partdefinition.addOrReplaceChild("centaur", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = centaur.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)-18.5f, (float)-6.0f));
        PartDefinition waist = bodybottom.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(64, 0).addBox(-3.5f, 0.0f, -2.0f, 7.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)-1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition bonemiddleFemale = bodymiddle.addOrReplaceChild("bonemiddleFemale", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -0.5f, -2.5f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, 0.0f, -2.6f, 1.0f, 2.0f, 0.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)1.0f));
        PartDefinition bodymidMale = bodymiddle.addOrReplaceChild("bodymidMale", CubeListBuilder.create().texOffs(0, 59).addBox(-2.5f, -2.5f, -1.5f, 5.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(36, 33).addBox(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)3.0f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(36, 33).addBox(0.0f, -1.0f, 0.0f, 0.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition hair1 = neck.addOrReplaceChild("hair1", CubeListBuilder.create().texOffs(36, 14).addBox(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hair2 = hair1.addOrReplaceChild("hair2", CubeListBuilder.create().texOffs(36, 25).addBox(-4.5f, 0.0f, -2.5f, 9.0f, 9.0f, 3.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)4.0f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition bonetopFemale = bodytop.addOrReplaceChild("bonetopFemale", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -3.0f, 5.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition bodytopmale = bodytop.addOrReplaceChild("bodytopmale", CubeListBuilder.create().texOffs(0, 50).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(24, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-5.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(24, 18).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition rightpauldron = rightarm.addOrReplaceChild("rightpauldron", CubeListBuilder.create().texOffs(36, 41).addBox(-2.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)2.5f, (float)-5.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 18).addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftpauldron = leftarm.addOrReplaceChild("leftpauldron", CubeListBuilder.create().texOffs(36, 41).addBox(-0.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body1 = centaur.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(64, 11).addBox(-4.0f, -1.0f, -1.0f, 8.0f, 9.0f, 9.0f), PartPose.offset((float)0.0f, (float)-18.5f, (float)-8.5f));
        PartDefinition body2 = body1.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(64, 29).addBox(-3.5f, -0.5f, -2.0f, 7.0f, 8.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)8.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body2.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(106, 51).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)9.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegback1 = body2.addOrReplaceChild("rightlegback1", CubeListBuilder.create().texOffs(106, 26).addBox(-1.0f, -2.5f, -2.5f, 3.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)-3.5f, (float)3.5f, (float)7.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegback2 = rightlegback1.addOrReplaceChild("rightlegback2", CubeListBuilder.create().texOffs(106, 40).addBox(-1.505f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.5f, (float)5.5f, (float)-2.5f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegback3 = rightlegback2.addOrReplaceChild("rightlegback3", CubeListBuilder.create().texOffs(106, 49).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 7.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftlegback1 = body2.addOrReplaceChild("leftlegback1", CubeListBuilder.create().texOffs(106, 26).addBox(-2.0f, -2.5f, -2.5f, 3.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)3.5f, (float)3.5f, (float)7.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leftlegback2 = leftlegback1.addOrReplaceChild("leftlegback2", CubeListBuilder.create().texOffs(106, 40).addBox(-1.395f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)-0.6f, (float)5.5f, (float)-2.5f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition leftlegback3 = leftlegback2.addOrReplaceChild("leftlegback3", CubeListBuilder.create().texOffs(106, 49).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 7.0f, 2.0f), PartPose.offsetAndRotation((float)0.1f, (float)6.0f, (float)3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegupper = body1.addOrReplaceChild("rightlegupper", CubeListBuilder.create().texOffs(106, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)-4.0f, (float)4.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition rightleglower = rightlegupper.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(106, 16).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f), PartPose.offset((float)0.0f, (float)6.5f, (float)-1.5f));
        PartDefinition rightlegbracelet = rightleglower.addOrReplaceChild("rightlegbracelet", CubeListBuilder.create().texOffs(106, 11).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)2.5f));
        PartDefinition leftlegupper = body1.addOrReplaceChild("leftlegupper", CubeListBuilder.create().texOffs(106, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)4.0f, (float)4.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition leftleglower = leftlegupper.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(106, 16).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f), PartPose.offset((float)0.0f, (float)6.5f, (float)-1.5f));
        PartDefinition leftlegbracelet = leftleglower.addOrReplaceChild("leftlegbracelet", CubeListBuilder.create().texOffs(106, 11).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)2.6f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Centaur centaur, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)centaur, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !centaur.isBaby();
    }

    public void setupAnim(Centaur centaur, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        if (centaur.isMale()) {
            this.rightarm.x = -3.0f;
            this.leftarm.x = 3.0f;
        }
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        if (centaur.isAggressive() && centaur.getMainHandItem().getItem() instanceof BowItem) {
            this.holdingBow(ageInTicks);
        } else if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        if (centaur.isFleeing()) {
            Vec3 movement = centaur.getDeltaMovement();
            if (movement.x * movement.x + movement.z * movement.z > 2.500000277905201E-7) {
                this.animationFlee();
            }
        }
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.body1.xRot = -0.08726646f;
        this.body2.xRot = 0.17453292f;
        this.tail.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.17453292f;
        this.tail.xRot = -0.7853982f;
        this.rightlegupper.zRot = -0.08726646f;
        this.rightlegupper.xRot = Mth.cos((float)(limbSwing * 0.7862f)) * 0.8f * limbSwingAmount;
        this.leftlegupper.zRot = 0.08726646f;
        this.leftlegupper.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightlegback1.zRot = -0.08726646f;
        this.rightlegback1.xRot = Mth.cos((float)(limbSwing * 0.7662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightlegback1.xRot -= 0.296706f;
        this.leftlegback1.zRot = 0.08726646f;
        this.leftlegback1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.leftlegback1.xRot -= 0.296706f;
        this.leftlegback2.xRot = this.rightlegback2.xRot = 0.5235988f;
        this.leftlegback3.xRot = this.rightlegback3.xRot = -0.31415927f;
        if (this.riding) {
            this.body1.xRot = -0.34906584f;
            this.body2.xRot = -0.7853982f;
            this.tail.xRot = 1.134464f;
            this.rightlegback1.zRot = 0.43633232f;
            this.leftlegback1.zRot = -this.rightlegback1.zRot;
            this.leftlegupper.xRot = this.rightlegupper.xRot = -0.43633232f;
            this.leftlegback1.xRot = this.rightlegback1.xRot = -0.34906584f;
        }
    }

    private void holdingBow(float ageInTicks) {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        float f1 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        this.rightarm.yRot = -(0.1f - f * 0.6f);
        this.leftarm.yRot = 0.1f - f * 0.6f;
        this.rightarm.xRot = -1.5707964f;
        this.leftarm.xRot = -1.5707964f;
        this.rightarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.leftarm.xRot -= f * 1.2f - f1 * 0.4f;
        AnimationUtils.bobArms((ModelPart)this.rightarm, (ModelPart)this.leftarm, (float)ageInTicks);
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationFlee() {
        this.leftarm.xRot += 1.0472f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.0625, 0.0, -0.375);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

