/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Cecaelia;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class CecaeliaModel
extends EntityModel<Cecaelia>
implements HeadedModel,
ArmedModel {
    private static final double CYCLES_PER_BLOCK = 0.1;
    private final float[][] undulationCycle = new float[][]{{10.0f, -10.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, -10.0f}, {5.0f, 10.0f, -10.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f}, {0.0f, 25.0f, 0.0f, -10.0f, -10.0f, 0.0f, 10.0f, 10.0f}, {-10.0f, 10.0f, 10.0f, 0.0f, -10.0f, -10.0f, 0.0f, 10.0f}, {-5.0f, -10.0f, 10.0f, 10.0f, 0.0f, -10.0f, -10.0f, 0.0f}, {-10.0f, 10.0f, 10.0f, 0.0f, -10.0f, -10.0f, 0.0f, 10.0f}, {0.0f, 25.0f, 0.0f, -10.0f, -10.0f, 0.0f, 10.0f, 10.0f}, {5.0f, 10.0f, -10.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f}};
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart[] tailsSW;
    private final ModelPart[] tailsSE;
    private final ModelPart[] tailsNW;
    private final ModelPart[] tailsNE;

    public CecaeliaModel(ModelPart root) {
        this.root = root.getChild("cecaelia");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        ModelPart tailbase = this.root.getChild("tailbase1");
        this.tailsSW = this.getTailParts(tailbase, "sw");
        this.tailsSE = this.getTailParts(tailbase, "se");
        this.tailsNW = this.getTailParts(tailbase, "nw");
        this.tailsNE = this.getTailParts(tailbase, "ne");
    }

    private ModelPart[] getTailParts(ModelPart root, String direction) {
        ModelPart[] tails;
        tails = new ModelPart[]{root.getChild("tailbase" + direction), tails[0].getChild("tail1" + direction), tails[1].getChild("tail2" + direction), tails[2].getChild("tail3" + direction)};
        return tails;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition cecaelia = partdefinition.addOrReplaceChild("cecaelia", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = cecaelia.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.05f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.15f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.05f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-0.05f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f).texOffs(36, 14).addBox(-4.5f, -5.5f, -2.5f, 3.0f, 3.0f, 3.0f).texOffs(36, 14).mirror().addBox(1.5f, -5.5f, -2.5f, 3.0f, 3.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition righttentacle = head.addOrReplaceChild("righttentacle", CubeListBuilder.create().texOffs(36, 20).addBox(-5.0f, -8.0f, 1.0f, 4.0f, 4.0f, 4.0f).texOffs(36, 28).addBox(-6.0f, -5.0f, 3.0f, 3.0f, 3.0f, 3.0f).texOffs(36, 34).addBox(-7.0f, -6.0f, 5.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lefttentacle = head.addOrReplaceChild("lefttentacle", CubeListBuilder.create().texOffs(36, 20).addBox(1.0f, -8.0f, 1.0f, 4.0f, 4.0f, 4.0f).texOffs(36, 28).addBox(3.0f, -5.0f, 3.0f, 3.0f, 3.0f, 3.0f).texOffs(36, 34).addBox(5.0f, -6.0f, 5.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition righttentaclelower = head.addOrReplaceChild("righttentaclelower", CubeListBuilder.create().texOffs(36, 38).addBox(-5.0f, -1.0f, 2.0f, 3.0f, 6.0f, 3.0f).texOffs(36, 47).addBox(-6.0f, 4.0f, 4.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftentaclelower = head.addOrReplaceChild("leftentaclelower", CubeListBuilder.create().texOffs(36, 38).addBox(2.0f, -1.0f, 2.0f, 3.0f, 6.0f, 3.0f).texOffs(36, 47).addBox(4.0f, 4.0f, 4.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).mirror().addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition tailbase1 = cecaelia.addOrReplaceChild("tailbase1", CubeListBuilder.create().texOffs(64, 0).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 3.0f, 7.0f).texOffs(64, 10).addBox(-4.5f, 2.0f, -4.5f, 9.0f, 6.0f, 9.0f), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition tailbasew_r1 = tailbase1.addOrReplaceChild("tailbasew_r1", CubeListBuilder.create().texOffs(100, 23).addBox(-1.0f, 0.0f, -4.5f, 1.0f, 6.0f, 9.0f), PartPose.offsetAndRotation((float)4.5f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition tailbases_r1 = tailbase1.addOrReplaceChild("tailbases_r1", CubeListBuilder.create().texOffs(100, 5).addBox(-4.5f, 0.0f, -1.0f, 9.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)4.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tailbasee_r1 = tailbase1.addOrReplaceChild("tailbasee_r1", CubeListBuilder.create().texOffs(100, 10).addBox(0.0f, 0.0f, -4.5f, 1.0f, 6.0f, 9.0f), PartPose.offsetAndRotation((float)-4.5f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition tailbasen_r1 = tailbase1.addOrReplaceChild("tailbasen_r1", CubeListBuilder.create().texOffs(100, 0).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-4.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tailbasesw = tailbase1.addOrReplaceChild("tailbasesw", CubeListBuilder.create().texOffs(64, 25).addBox(-1.0f, -3.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)2.5f, (float)8.0f, (float)-2.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition tail1sw = tailbasesw.addOrReplaceChild("tail1sw", CubeListBuilder.create().texOffs(64, 36).addBox(-1.0f, 0.0f, -2.5f, 6.0f, 5.0f, 5.0f), PartPose.offset((float)4.0f, (float)-3.5f, (float)0.0f));
        PartDefinition tail2sw = tail1sw.addOrReplaceChild("tail2sw", CubeListBuilder.create().texOffs(64, 46).addBox(-1.0f, 0.0f, -2.0f, 5.0f, 4.0f, 4.0f), PartPose.offset((float)5.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail3sw = tail2sw.addOrReplaceChild("tail3sw", CubeListBuilder.create().texOffs(64, 54).addBox(-1.0f, 0.0f, -1.5f, 4.0f, 3.0f, 3.0f), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail4sw = tail3sw.addOrReplaceChild("tail4sw", CubeListBuilder.create().texOffs(64, 60).addBox(-1.0f, 0.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition tailbasese = tailbase1.addOrReplaceChild("tailbasese", CubeListBuilder.create().texOffs(64, 25).mirror().addBox(-4.0f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.5f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)7.0f, (float)-2.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition tail1se = tailbasese.addOrReplaceChild("tail1se", CubeListBuilder.create().texOffs(64, 36).addBox(-6.0f, 0.0f, -2.5f, 6.0f, 5.0f, 5.0f), PartPose.offset((float)-3.0f, (float)-2.5f, (float)0.0f));
        PartDefinition tail2se = tail1se.addOrReplaceChild("tail2se", CubeListBuilder.create().texOffs(64, 46).addBox(-4.0f, 0.0f, -2.0f, 5.0f, 4.0f, 4.0f), PartPose.offset((float)-6.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail3se = tail2se.addOrReplaceChild("tail3se", CubeListBuilder.create().texOffs(64, 54).addBox(-3.0f, 0.0f, -1.5f, 4.0f, 3.0f, 3.0f), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail4se = tail3se.addOrReplaceChild("tail4se", CubeListBuilder.create().texOffs(64, 60).addBox(-2.0f, 0.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        PartDefinition tailbasenw = tailbase1.addOrReplaceChild("tailbasenw", CubeListBuilder.create().texOffs(64, 25).addBox(-1.0f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)2.5f, (float)7.0f, (float)2.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition tail1nw = tailbasenw.addOrReplaceChild("tail1nw", CubeListBuilder.create().texOffs(64, 36).addBox(-1.0f, 0.0f, -2.5f, 6.0f, 5.0f, 5.0f), PartPose.offset((float)4.0f, (float)-2.5f, (float)0.0f));
        PartDefinition tail2nw = tail1nw.addOrReplaceChild("tail2nw", CubeListBuilder.create().texOffs(64, 46).addBox(-1.0f, 0.0f, -2.0f, 5.0f, 4.0f, 4.0f), PartPose.offset((float)5.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail3nw = tail2nw.addOrReplaceChild("tail3nw", CubeListBuilder.create().texOffs(64, 54).addBox(-1.0f, 0.0f, -1.5f, 4.0f, 3.0f, 3.0f), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail4nw = tail3nw.addOrReplaceChild("tail4nw", CubeListBuilder.create().texOffs(64, 60).addBox(-1.0f, 0.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition tailbasene = tailbase1.addOrReplaceChild("tailbasene", CubeListBuilder.create().texOffs(64, 25).mirror().addBox(-4.0f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.5f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)7.0f, (float)2.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition tail1ne = tailbasene.addOrReplaceChild("tail1ne", CubeListBuilder.create().texOffs(64, 36).addBox(-5.0f, 0.0f, -2.5f, 6.0f, 5.0f, 5.0f), PartPose.offset((float)-4.0f, (float)-2.5f, (float)0.0f));
        PartDefinition tail2ne = tail1ne.addOrReplaceChild("tail2ne", CubeListBuilder.create().texOffs(64, 46).addBox(-4.0f, 0.0f, -2.0f, 5.0f, 4.0f, 4.0f), PartPose.offset((float)-5.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail3ne = tail2ne.addOrReplaceChild("tail3ne", CubeListBuilder.create().texOffs(64, 54).addBox(-3.0f, 0.0f, -1.5f, 4.0f, 3.0f, 3.0f), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail4ne = tail3ne.addOrReplaceChild("tail4ne", CubeListBuilder.create().texOffs(64, 60).addBox(-2.0f, 0.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Cecaelia cecaelia, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)cecaelia, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !cecaelia.isBaby();
    }

    public void setupAnim(Cecaelia cecaelia, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float radAngle;
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        if (cecaelia.isThrowing()) {
            this.animationThrow();
        } else {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            float armDefaultAngleZ = 0.1745329f;
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + armDefaultAngleZ;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + armDefaultAngleZ;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        }
        float usedValue = cecaelia.isInWater() ? ageInTicks : limbSwing;
        int cycleIndex = (int)((double)usedValue * 0.1 % (double)this.undulationCycle.length);
        this.tailsSW[0].yRot = radAngle = 0.785398f;
        this.tailsSW[1].yRot = 0.15f * Mth.cos((float)(usedValue * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][1])));
        this.tailsSW[2].yRot = 0.15f * Mth.cos((float)(usedValue * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][2])));
        this.tailsSW[3].yRot = 0.15f * Mth.cos((float)(usedValue * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][3])));
        this.tailsSW[1].zRot = -radAngle;
        this.tailsSW[2].zRot = -radAngle;
        this.tailsSW[3].zRot = -radAngle;
        this.tailsSE[0].yRot = -radAngle;
        this.tailsSE[1].yRot = this.tailsSW[1].yRot;
        this.tailsSE[2].yRot = this.tailsSW[2].yRot;
        this.tailsSE[3].yRot = this.tailsSW[3].yRot;
        this.tailsSE[1].zRot = radAngle;
        this.tailsSE[2].zRot = radAngle;
        this.tailsSE[3].zRot = radAngle;
        this.tailsNW[0].yRot = -radAngle;
        this.tailsNW[1].yRot = this.tailsSW[1].yRot;
        this.tailsNW[2].yRot = this.tailsSW[2].yRot;
        this.tailsNW[3].yRot = this.tailsSW[3].yRot;
        this.tailsNW[1].zRot = -radAngle;
        this.tailsNW[2].zRot = -radAngle;
        this.tailsNW[3].zRot = -radAngle;
        this.tailsNE[0].yRot = radAngle;
        this.tailsNE[1].yRot = this.tailsSW[1].yRot;
        this.tailsNE[2].yRot = this.tailsSW[2].yRot;
        this.tailsNE[3].yRot = this.tailsSW[3].yRot;
        this.tailsNE[1].zRot = radAngle;
        this.tailsNE[2].zRot = radAngle;
        this.tailsNE[3].zRot = radAngle;
        if (cecaelia.isInWater()) {
            this.tailsSW[0].zRot = -(0.3f * Mth.cos((float)(ageInTicks * 0.06f)));
            this.tailsSW[1].zRot = -(0.3f * Mth.cos((float)(ageInTicks * 0.06f)));
            this.tailsSW[2].zRot = -(0.3f * Mth.cos((float)(ageInTicks * 0.06f)));
            this.tailsSW[3].zRot = -(0.3f * Mth.cos((float)(ageInTicks * 0.06f)));
            this.tailsSE[0].zRot = 0.3f * Mth.cos((float)(ageInTicks * 0.06f));
            this.tailsSE[1].zRot = 0.3f * Mth.cos((float)(ageInTicks * 0.06f));
            this.tailsSE[2].zRot = 0.3f * Mth.cos((float)(ageInTicks * 0.06f));
            this.tailsSE[3].zRot = 0.3f * Mth.cos((float)(ageInTicks * 0.06f));
            this.tailsNW[0].zRot = -(0.3f * Mth.cos((float)(ageInTicks * 0.06f)));
            this.tailsNW[1].zRot = -(0.3f * Mth.cos((float)(ageInTicks * 0.06f)));
            this.tailsNW[2].zRot = -(0.3f * Mth.cos((float)(ageInTicks * 0.06f)));
            this.tailsNW[3].zRot = -(0.3f * Mth.cos((float)(ageInTicks * 0.06f)));
            this.tailsNE[0].zRot = 0.3f * Mth.cos((float)(ageInTicks * 0.06f));
            this.tailsNE[1].zRot = 0.3f * Mth.cos((float)(ageInTicks * 0.06f));
            this.tailsNE[2].zRot = 0.3f * Mth.cos((float)(ageInTicks * 0.06f));
            this.tailsNE[3].zRot = 0.3f * Mth.cos((float)(ageInTicks * 0.06f));
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        this.rightarm.xRot = -1.0472f;
        this.leftarm.xRot = -1.0472f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, 0.0625);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

