/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Bee;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class BeeModel
extends EntityModel<Bee>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodybottom;
    private final ModelPart bodymiddle;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftwing;
    private final ModelPart rightwing;
    private final ModelPart thorax1;
    private final ModelPart leftleg;
    private final ModelPart rightleg;
    private final ModelPart leftleglower;
    private final ModelPart rightleglower;
    private float offset = 0.0f;

    public BeeModel(ModelPart root) {
        this.root = root.getChild("bee");
        this.bodybottom = this.root.getChild("bodybottom");
        this.bodymiddle = this.bodybottom.getChild("bodymiddle");
        this.bodytop = this.bodymiddle.getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.leftwing = this.bodytop.getChild("leftwing1");
        this.rightwing = this.bodytop.getChild("rightwing1");
        this.thorax1 = this.bodybottom.getChild("thorax1");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
        this.leftleglower = this.leftleg.getChild("leftleglower");
        this.rightleglower = this.rightleg.getChild("rightleglower");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bee = partdefinition.addOrReplaceChild("bee", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = bee.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -1.5f, 5.0f, 6.0f, 3.0f).texOffs(36, 33).addBox(-3.5f, -6.0f, -1.5f, 7.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f).texOffs(36, 14).addBox(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.5f, -6.5f, -3.25f, 7.0f, 7.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightantenna = head.addOrReplaceChild("rightantenna", CubeListBuilder.create().texOffs(36, 25).addBox(-2.0f, -8.0f, -5.0f, 1.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition leftantenna = head.addOrReplaceChild("leftantenna", CubeListBuilder.create().texOffs(36, 25).addBox(1.0f, -8.0f, -5.0f, 1.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-1.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).texOffs(36, 39).addBox(-1.505f, 3.0f, -2.5f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).mirror().addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).mirror(false).texOffs(36, 39).mirror().addBox(-1.495f, 3.0f, -2.5f, 3.0f, 2.0f, 3.0f).mirror(false), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition rightwing1 = bodytop.addOrReplaceChild("rightwing1", CubeListBuilder.create().texOffs(64, -10).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 10.0f), PartPose.offsetAndRotation((float)1.5f, (float)-4.0f, (float)1.5f, (float)0.5236f, (float)0.7854f, (float)0.0f));
        PartDefinition rightwing2_r1 = rightwing1.addOrReplaceChild("rightwing2_r1", CubeListBuilder.create().texOffs(64, -10).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 10.0f), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition leftwing1 = bodytop.addOrReplaceChild("leftwing1", CubeListBuilder.create().texOffs(74, -10).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 10.0f), PartPose.offsetAndRotation((float)-1.5f, (float)-4.0f, (float)1.5f, (float)0.5236f, (float)-0.7854f, (float)0.0f));
        PartDefinition leftwing2_r1 = leftwing1.addOrReplaceChild("leftwing2_r1", CubeListBuilder.create().texOffs(74, -10).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 10.0f), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition thorax1 = bodybottom.addOrReplaceChild("thorax1", CubeListBuilder.create().texOffs(64, 6).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)1.5f));
        PartDefinition thorax2 = thorax1.addOrReplaceChild("thorax2", CubeListBuilder.create().texOffs(64, 12).addBox(-2.5f, -1.0f, 0.0f, 5.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition thorax3 = thorax2.addOrReplaceChild("thorax3", CubeListBuilder.create().texOffs(64, 22).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = bee.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)-2.0f, (float)-13.0f, (float)0.5f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(24, 22).addBox(-1.49f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).texOffs(94, 0).addBox(-2.0f, 6.0f, -0.5f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition leftleg = bee.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)2.0f, (float)-13.0f, (float)0.5f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(24, 22).addBox(-1.51f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).texOffs(94, 0).addBox(-2.0f, 6.0f, -0.5f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Bee bee, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)bee, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !bee.isBaby();
    }

    public void setupAnim(Bee bee, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legsAngleMoving;
        float armsAngleMoving;
        boolean moveExtremities;
        boolean moving;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        float defaultAngle = 0.0f;
        boolean bl = moving = limbSwingAmount > 0.1f;
        if (moving) {
            moveExtremities = false;
            armsAngleMoving = -1.5707964f;
            legsAngleMoving = 0.08726646f;
            this.bodytop.xRot = 0.5235988f;
            this.rightarm.xRot = armsAngleMoving;
            this.leftarm.xRot = armsAngleMoving;
            this.bodymiddle.xRot = 0.43633232f;
            this.thorax1.xRot = 0.5235988f;
            this.bodybottom.xRot = 0.2617994f;
            this.rightleg.xRot = legsAngleMoving;
            this.leftleg.xRot = legsAngleMoving;
            this.rightleglower.xRot = 1.3089969f;
            this.leftleglower.xRot = 1.3089969f;
            this.head.xRot = -45.0f + headPitch / 57.295776f;
        } else {
            moveExtremities = true;
            armsAngleMoving = defaultAngle;
            legsAngleMoving = defaultAngle;
            this.bodytop.xRot = defaultAngle;
            this.rightarm.xRot = armsAngleMoving;
            this.leftarm.xRot = armsAngleMoving;
            this.bodymiddle.xRot = defaultAngle;
            this.thorax1.xRot = defaultAngle;
            this.bodybottom.xRot = defaultAngle;
            this.rightleg.xRot = legsAngleMoving;
            this.leftleg.xRot = legsAngleMoving;
            this.rightleglower.xRot = defaultAngle;
            this.leftleglower.xRot = defaultAngle;
        }
        this.offset = Mth.cos((float)(ageInTicks * 0.18f)) * 0.9f;
        this.root.y = 24.0f - this.offset;
        int animationState = bee.getAnimationState();
        if (animationState == 0) {
            if (moveExtremities) {
                this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
                this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            }
            if (!moveExtremities) {
                this.rightarm.xRot = armsAngleMoving;
                this.leftarm.xRot = armsAngleMoving;
            }
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.1745329f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.1745329f;
        }
        if (animationState == 1) {
            this.animationThrow();
        }
        float swingSpeed = 0.2f;
        float angleRange = 1.0f;
        float wingDefaultAngleY = 0.7853982f;
        this.leftwing.yRot = Mth.cos((float)(ageInTicks * swingSpeed + (float)Math.PI)) * angleRange * 0.5f;
        this.leftwing.yRot -= wingDefaultAngleY;
        this.rightwing.yRot = Mth.cos((float)(ageInTicks * swingSpeed)) * angleRange * 0.5f;
        this.rightwing.yRot += wingDefaultAngleY;
        this.thorax1.xRot += Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        if (animationState == 0) {
            if (moveExtremities) {
                this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
                this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
            }
            float swingSpeed2 = 0.2f;
            float angleRange2 = 0.1f;
            if (!moveExtremities) {
                this.rightleg.xRot = legsAngleMoving;
                this.leftleg.xRot = legsAngleMoving;
            }
            this.rightleg.zRot = Mth.cos((float)(ageInTicks * swingSpeed2 + (float)Math.PI)) * angleRange2 * -0.5f;
            this.leftleg.zRot = Mth.cos((float)(ageInTicks * swingSpeed2)) * angleRange2 * -0.5f;
            this.rightleg.yRot = 0.0f;
            this.leftleg.yRot = 0.0f;
            this.rightleg.zRot = 0.0f;
            this.leftleg.zRot = 0.0f;
        }
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        float armsAngleThrow = -1.0471976f;
        float legsAngleThrow = 0.34906584f;
        this.rightarm.xRot = armsAngleThrow;
        this.leftarm.xRot = armsAngleThrow;
        this.rightleg.xRot = legsAngleThrow;
        this.leftleg.xRot = legsAngleThrow;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
        poseStack.translate(0.0f, -(this.offset * 0.05f), 0.0f);
    }
}

