/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Arachne;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class ArachneModel
extends EntityModel<Arachne>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart body4;
    private final ModelPart body5;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightMiddleHindLeg;
    private final ModelPart leftMiddleHindLeg;
    private final ModelPart rightMiddleFrontLeg;
    private final ModelPart leftMiddleFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public ArachneModel(ModelPart root) {
        this.root = root.getChild("arachne");
        ModelPart bodybottom = this.root.getChild("body1").getChild("bodybottom");
        ModelPart body3 = this.root.getChild("body3");
        this.body4 = body3.getChild("body4");
        this.body5 = body3.getChild("body5");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        this.head = this.bodytop.getChild("neck").getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.rightHindLeg = this.root.getChild("right_hind_leg");
        this.leftHindLeg = this.root.getChild("left_hind_leg");
        this.rightMiddleHindLeg = this.root.getChild("right_middle_hind_leg");
        this.leftMiddleHindLeg = this.root.getChild("left_middle_hind_leg");
        this.rightMiddleFrontLeg = this.root.getChild("right_middle_front_leg");
        this.leftMiddleFrontLeg = this.root.getChild("left_middle_front_leg");
        this.rightFrontLeg = this.root.getChild("right_front_leg");
        this.leftFrontLeg = this.root.getChild("left_front_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition arachne = partdefinition.addOrReplaceChild("arachne", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body1 = arachne.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(64, 0).addBox(-3.0f, -4.0f, -8.0f, 6.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition bodybottom = body1.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-8.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition waist_r1 = bodybottom.addOrReplaceChild("waist_r1", CubeListBuilder.create().texOffs(36, 37).addBox(-3.5f, 0.0f, -2.0f, 7.0f, 5.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -1.5f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -1.6f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)2.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 9.0f, 7.0f).texOffs(36, 16).addBox(-4.0f, -7.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(36, 16).mirror().addBox(2.0f, -7.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false).texOffs(36, 20).addBox(-2.0f, -7.0f, 1.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.7f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 19).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 5.0f, 2.0f).texOffs(36, 28).addBox(-1.5f, -0.5f, -2.5f, 2.0f, 6.0f, 3.0f), PartPose.offset((float)-1.0f, (float)4.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 19).mirror().addBox(-0.995f, 0.0f, -2.0f, 2.0f, 5.0f, 2.0f).mirror(false).texOffs(36, 28).mirror().addBox(-0.5f, -0.5f, -2.5f, 2.0f, 6.0f, 3.0f).mirror(false), PartPose.offset((float)1.0f, (float)4.0f, (float)1.0f));
        PartDefinition body2 = body1.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(64, 16).addBox(-3.5f, -6.0f, 0.0f, 7.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition body3 = arachne.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(78, 34).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 10.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)7.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition body4 = body3.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(64, 30).addBox(-2.5f, 0.0f, -8.0f, 5.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)-6.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition body5 = body3.addOrReplaceChild("body5", CubeListBuilder.create().texOffs(64, 56).addBox(-2.0f, -1.5f, -1.5f, 4.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)6.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = arachne.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(92, 0).addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-9.0f, (float)2.0f, (float)0.0f, (float)0.576f, (float)-0.4887f));
        PartDefinition left_hind_leg = arachne.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(92, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)-9.0f, (float)2.0f, (float)0.0f, (float)-0.576f, (float)0.4887f));
        PartDefinition right_middle_hind_leg = arachne.addOrReplaceChild("right_middle_hind_leg", CubeListBuilder.create().texOffs(92, 0).addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-9.0f, (float)1.0f, (float)0.0f, (float)0.2793f, (float)-0.5585f));
        PartDefinition left_middle_hind_leg = arachne.addOrReplaceChild("left_middle_hind_leg", CubeListBuilder.create().texOffs(92, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)-9.0f, (float)1.0f, (float)0.0f, (float)-0.2793f, (float)0.5585f));
        PartDefinition right_middle_front_leg = arachne.addOrReplaceChild("right_middle_front_leg", CubeListBuilder.create().texOffs(92, 0).addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)-0.2793f, (float)-0.5585f));
        PartDefinition left_middle_front_leg = arachne.addOrReplaceChild("left_middle_front_leg", CubeListBuilder.create().texOffs(92, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.2793f, (float)0.5585f));
        PartDefinition right_front_leg = arachne.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(92, 0).addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-9.0f, (float)-1.0f, (float)0.0f, (float)-0.576f, (float)-0.5585f));
        PartDefinition left_front_leg = arachne.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(92, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)-9.0f, (float)-1.0f, (float)0.0f, (float)0.576f, (float)0.5585f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Arachne arachne, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)arachne, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !arachne.isBaby();
    }

    public void setupAnim(Arachne arachne, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        int attackType = arachne.getAttackType();
        if (attackType == 0) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
            this.rightarm.zRot += 0.3490659f;
            this.leftarm.zRot -= 0.3490659f;
        } else if (attackType == 1) {
            this.animationThrow();
        } else if (attackType == 2) {
            this.animationCast();
        }
        float chestDefaultRotateAngleX = 0.8726646f;
        this.chest.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount + chestDefaultRotateAngleX;
        this.body4.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.1f * limbSwingAmount;
        this.body5.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.05f * limbSwingAmount;
        this.body4.xRot -= 0.4363323f;
        this.moveLegs(limbSwing, limbSwingAmount);
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.leftarm.xRot = (float)((double)this.leftarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.leftarm.xRot += this.bodytop.yRot * 2.0f;
        this.leftarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        this.rightarm.xRot = -1.0472f;
    }

    private void animationCast() {
        this.rightarm.xRot = -1.0472f;
        this.leftarm.xRot = -1.0472f;
        this.rightarm.zRot = -0.261799f;
        this.leftarm.zRot = 0.261799f;
    }

    public void moveLegs(float limbSwing, float limbSwingAmount) {
        float f = 0.7853982f;
        this.rightHindLeg.zRot = -f;
        this.leftHindLeg.zRot = f;
        this.rightMiddleHindLeg.zRot = -0.58119464f;
        this.leftMiddleHindLeg.zRot = 0.58119464f;
        this.rightMiddleFrontLeg.zRot = -0.58119464f;
        this.leftMiddleFrontLeg.zRot = 0.58119464f;
        this.rightFrontLeg.zRot = -f;
        this.leftFrontLeg.zRot = f;
        float f2 = 0.3926991f;
        this.rightHindLeg.yRot = f;
        this.leftHindLeg.yRot = -f;
        this.rightMiddleHindLeg.yRot = f2;
        this.leftMiddleHindLeg.yRot = -0.3926991f;
        this.rightMiddleFrontLeg.yRot = -0.3926991f;
        this.leftMiddleFrontLeg.yRot = f2;
        this.rightFrontLeg.yRot = -f;
        this.leftFrontLeg.yRot = f;
        float f3 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f4 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f5 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float f6 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float f7 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f8 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f9 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float f10 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.rightHindLeg.yRot += f3;
        this.leftHindLeg.yRot -= f3;
        this.rightMiddleHindLeg.yRot += f4;
        this.leftMiddleHindLeg.yRot -= f4;
        this.rightMiddleFrontLeg.yRot += f5;
        this.leftMiddleFrontLeg.yRot -= f5;
        this.rightFrontLeg.yRot += f6;
        this.leftFrontLeg.yRot -= f6;
        this.rightHindLeg.zRot += f7;
        this.leftHindLeg.zRot -= f7;
        this.rightMiddleHindLeg.zRot += f8;
        this.leftMiddleHindLeg.zRot -= f8;
        this.rightMiddleFrontLeg.zRot += f9;
        this.leftMiddleFrontLeg.zRot -= f9;
        this.rightFrontLeg.zRot += f10;
        this.leftFrontLeg.zRot -= f10;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, -0.425);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

