/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.AntSalvager;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AntSalvagerModel
extends EntityModel<AntSalvager> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart thorax1;

    public AntSalvagerModel(ModelPart root) {
        this.root = root.getChild("ant_ranger");
        ModelPart bodylower = this.root.getChild("bodylower");
        ModelPart bodyupper = bodylower.getChild("bodyupper");
        this.head = bodyupper.getChild("head");
        this.rightarm = bodyupper.getChild("rightarm");
        this.leftarm = bodyupper.getChild("leftarm");
        this.thorax1 = bodylower.getChild("thorax1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition ant_ranger = partdefinition.addOrReplaceChild("ant_ranger", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodylower = ant_ranger.addOrReplaceChild("bodylower", CubeListBuilder.create().texOffs(32, 10).addBox(-2.5f, 5.0f, -1.5f, 5.0f, 6.0f, 5.0f), PartPose.offset((float)0.0f, (float)-6.5f, (float)0.0f));
        PartDefinition bodyupper = bodylower.addOrReplaceChild("bodyupper", CubeListBuilder.create().texOffs(32, 0).addBox(-2.0f, -4.0f, -4.0f, 4.0f, 6.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.5f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head = bodyupper.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -3.0f, -7.0f, 5.0f, 4.0f, 7.0f).texOffs(0, 11).addBox(-3.5f, -4.0f, -5.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 11).addBox(1.5f, -4.0f, -5.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightantenna = head.addOrReplaceChild("rightantenna", CubeListBuilder.create().texOffs(0, 15).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)-1.5f, (float)-3.0f, (float)-7.0f, (float)-0.2618f, (float)0.5236f, (float)0.0f));
        rightantenna.addOrReplaceChild("rightantennatop", CubeListBuilder.create().texOffs(0, 21).addBox(-0.5f, -1.005f, -4.0f, 1.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftantenna = head.addOrReplaceChild("leftantenna", CubeListBuilder.create().texOffs(0, 15).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)1.5f, (float)-3.0f, (float)-7.0f, (float)-0.2618f, (float)-0.5236f, (float)0.0f));
        leftantenna.addOrReplaceChild("leftantennatop", CubeListBuilder.create().texOffs(0, 21).addBox(-0.5f, -1.005f, -4.0f, 1.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("rightmandable", CubeListBuilder.create().texOffs(0, 27).addBox(-2.0f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)-2.5f, (float)1.0f, (float)-5.0f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        head.addOrReplaceChild("leftmandable", CubeListBuilder.create().texOffs(0, 27).mirror().addBox(-1.0f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)1.0f, (float)-5.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition rightarm = bodyupper.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(56, 0).addBox(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)-3.0f, (float)-0.3491f, (float)-0.7854f, (float)0.2618f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(56, 4).addBox(-0.005f, 0.0f, -1.005f, 2.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        rightarmlower.addOrReplaceChild("rightarmhand", CubeListBuilder.create().texOffs(56, 10).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)2.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition leftarm = bodyupper.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(56, 0).addBox(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)-3.0f, (float)-3.0f, (float)-0.3491f, (float)0.7854f, (float)-0.2618f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(56, 4).addBox(-2.0f, 0.0f, -1.005f, 2.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        leftarmlower.addOrReplaceChild("leftarmhand", CubeListBuilder.create().texOffs(56, 10).addBox(0.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)-2.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition rightleg = bodyupper.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(56, 15).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)-0.7854f, (float)0.2182f, (float)1.5708f));
        rightleg.addOrReplaceChild("rightlegfoot", CubeListBuilder.create().texOffs(56, 21).addBox(-1.0f, 2.0f, -4.0f, 2.0f, 2.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = bodyupper.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(56, 15).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)-2.0f, (float)-0.7854f, (float)-0.2182f, (float)-1.5708f));
        leftleg.addOrReplaceChild("leftlegfoot", CubeListBuilder.create().texOffs(56, 21).addBox(-1.0f, 2.0f, -4.0f, 2.0f, 2.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition thorax1 = bodylower.addOrReplaceChild("thorax1", CubeListBuilder.create().texOffs(32, 21).addBox(-3.0f, -1.0f, -1.0f, 6.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)2.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        thorax1.addOrReplaceChild("thorax2", CubeListBuilder.create().texOffs(32, 35).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(AntSalvager antSalvager, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        float swingSpeed = 0.1f;
        float angleRange = 0.1f;
        float mandableDefaultAngleY = 0.1745329f;
        this.rightarm.yRot = Mth.cos((float)(ageInTicks * swingSpeed + (float)Math.PI)) * angleRange * 0.5f;
        this.rightarm.yRot -= mandableDefaultAngleY;
        this.leftarm.yRot = Mth.cos((float)(ageInTicks * swingSpeed)) * angleRange * 0.5f;
        this.leftarm.yRot += mandableDefaultAngleY;
        this.thorax1.xRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

