/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.model;

import com.progwml6.ironchest.common.block.IronChestsTypes;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class IronChestsModels {
    public static final ResourceLocation IRON_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/iron_chest");
    public static final ResourceLocation GOLD_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/gold_chest");
    public static final ResourceLocation DIAMOND_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/diamond_chest");
    public static final ResourceLocation COPPER_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/copper_chest");
    public static final ResourceLocation CRYSTAL_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/crystal_chest");
    public static final ResourceLocation OBSIDIAN_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/obsidian_chest");
    public static final ResourceLocation DIRT_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/dirt_chest");
    public static final ResourceLocation VANILLA_CHEST_LOCATION = ResourceLocation.withDefaultNamespace((String)"entity/chest/normal");
    public static final ResourceLocation TRAPPED_IRON_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/trapped_iron_chest");
    public static final ResourceLocation TRAPPED_GOLD_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/trapped_gold_chest");
    public static final ResourceLocation TRAPPED_DIAMOND_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/trapped_diamond_chest");
    public static final ResourceLocation TRAPPED_COPPER_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/trapped_copper_chest");
    public static final ResourceLocation TRAPPED_CRYSTAL_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/trapped_crystal_chest");
    public static final ResourceLocation TRAPPED_OBSIDIAN_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/trapped_obsidian_chest");
    public static final ResourceLocation TRAPPED_DIRT_CHEST_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"ironchest", (String)"model/trapped_dirt_chest");
    public static final ResourceLocation TRAPPED_VANILLA_CHEST_LOCATION = ResourceLocation.withDefaultNamespace((String)"entity/chest/trapped");

    public static ResourceLocation chooseChestTexture(IronChestsTypes type, boolean trapped) {
        if (trapped) {
            return IronChestsModels.getResourceLocation(type, TRAPPED_IRON_CHEST_LOCATION, TRAPPED_GOLD_CHEST_LOCATION, TRAPPED_DIAMOND_CHEST_LOCATION, TRAPPED_COPPER_CHEST_LOCATION, TRAPPED_CRYSTAL_CHEST_LOCATION, TRAPPED_OBSIDIAN_CHEST_LOCATION, TRAPPED_DIRT_CHEST_LOCATION, TRAPPED_VANILLA_CHEST_LOCATION);
        }
        return IronChestsModels.getResourceLocation(type, IRON_CHEST_LOCATION, GOLD_CHEST_LOCATION, DIAMOND_CHEST_LOCATION, COPPER_CHEST_LOCATION, CRYSTAL_CHEST_LOCATION, OBSIDIAN_CHEST_LOCATION, DIRT_CHEST_LOCATION, VANILLA_CHEST_LOCATION);
    }

    @NotNull
    private static ResourceLocation getResourceLocation(IronChestsTypes type, ResourceLocation ironChestLocation, ResourceLocation goldChestLocation, ResourceLocation diamondChestLocation, ResourceLocation copperChestLocation, ResourceLocation crystalChestLocation, ResourceLocation obsidianChestLocation, ResourceLocation dirtChestLocation, ResourceLocation vanillaChestLocation) {
        return switch (type) {
            case IronChestsTypes.IRON -> ironChestLocation;
            case IronChestsTypes.GOLD -> goldChestLocation;
            case IronChestsTypes.DIAMOND -> diamondChestLocation;
            case IronChestsTypes.COPPER -> copperChestLocation;
            case IronChestsTypes.CRYSTAL -> crystalChestLocation;
            case IronChestsTypes.OBSIDIAN -> obsidianChestLocation;
            case IronChestsTypes.DIRT -> dirtChestLocation;
            default -> vanillaChestLocation;
        };
    }
}

