/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.registries.PlacementModifierRegistry;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class InSquare
extends PlacementModifier {
    public static final MapCodec<InSquare> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("margin").forGetter(config -> config.margin)).apply((Applicative)instance, InSquare::new));
    public final int margin;

    public InSquare(int margin) {
        this.margin = margin;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        int x = pos.getX() & 0xFFFFFFF0 | random.nextInt(16 - (this.margin << 1)) + this.margin;
        int z = pos.getZ() & 0xFFFFFFF0 | random.nextInt(16 - (this.margin << 1)) + this.margin;
        return Stream.of(new BlockPos(x, pos.getY(), z));
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)PlacementModifierRegistry.IN_SQUARE.get();
    }
}

