/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class WildwoodTree
extends DivineTree {
    public static BlockState westVines;
    public static BlockState eastVines;
    public static BlockState southVines;
    public static BlockState northVines;

    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.is((Block)BlockRegistry.wildwoodDirt.get()) || state.is((Block)BlockRegistry.wildwoodGrass.get());
    }

    private void growLeavesWithVines(WorldGenLevel world, RandomSource random, BlockPos pos, BlockState leaves, int maxY, int width, int offset, float leavesChance, float vineChance) {
        for (int minY = 0; minY <= maxY; ++minY) {
            this.chanceSetBlock(world, random, pos.offset(width, minY, offset), leaves, leavesChance);
            if (!world.getBlockState(pos.offset(width, minY, offset)).isAir()) {
                this.setBlockSensitive(world, random, pos.offset(width + 1, minY, offset), westVines, vineChance);
            }
            this.chanceSetBlock(world, random, pos.offset(-width, minY, -offset), leaves, leavesChance);
            if (!world.getBlockState(pos.offset(-width, minY, -offset)).isAir()) {
                this.setBlockSensitive(world, random, pos.offset(-width - 1, minY, -offset), eastVines, vineChance);
            }
            this.chanceSetBlock(world, random, pos.offset(offset, minY, -width), leaves, leavesChance);
            if (!world.getBlockState(pos.offset(offset, minY, -width)).isAir()) {
                this.setBlockSensitive(world, random, pos.offset(offset, minY, -width - 1), southVines, vineChance);
            }
            this.chanceSetBlock(world, random, pos.offset(-offset, minY, width), leaves, leavesChance);
            if (world.getBlockState(pos.offset(-offset, minY, width)).isAir()) continue;
            this.setBlockSensitive(world, random, pos.offset(-offset, minY, width + 1), northVines, vineChance);
        }
    }

    protected void growVines(WorldGenLevel world, RandomSource random, BlockPos pos, int maxY, int width, int offset, float chance) {
        for (int minY = 0; minY <= maxY; ++minY) {
            this.setBlockSensitive(world, random, pos.offset(width, minY, offset), westVines, chance);
            this.setBlockSensitive(world, random, pos.offset(-width, minY, -offset), eastVines, chance);
            this.setBlockSensitive(world, random, pos.offset(offset, minY, -width), southVines, chance);
            this.setBlockSensitive(world, random, pos.offset(-offset, minY, width), northVines, chance);
        }
    }

    private void growTheLeaves(WorldGenLevel world, RandomSource random, BlockPos pos, BlockState leaves, int maxY, float vineChance) {
        for (int offset = -1; offset < 2; offset = (int)((byte)(offset + 1))) {
            this.grow(world, pos, leaves, maxY, 2, offset);
            this.growVines(world, random, pos, maxY, 3, offset, vineChance);
        }
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int treeHeight;
            if (northVines == null) {
                northVines = (BlockState)((Block)BlockRegistry.wildwoodVine.get()).defaultBlockState().setValue((Property)VineBlock.NORTH, (Comparable)Boolean.valueOf(true));
                eastVines = (BlockState)((Block)BlockRegistry.wildwoodVine.get()).defaultBlockState().setValue((Property)VineBlock.EAST, (Comparable)Boolean.valueOf(true));
                southVines = (BlockState)((Block)BlockRegistry.wildwoodVine.get()).defaultBlockState().setValue((Property)VineBlock.SOUTH, (Comparable)Boolean.valueOf(true));
                westVines = (BlockState)((Block)BlockRegistry.wildwoodVine.get()).defaultBlockState().setValue((Property)VineBlock.WEST, (Comparable)Boolean.valueOf(true));
            }
            int treeType = random.nextInt(7);
            int extraHeight = switch (treeType) {
                case 0 -> {
                    treeHeight = 1 + random.nextInt(4);
                    yield treeHeight + 3;
                }
                case 1 -> {
                    treeHeight = 6 + random.nextInt(4);
                    yield treeHeight + 1;
                }
                case 2 -> {
                    if (random.nextInt(32) == 0) {
                        treeHeight = 15;
                        yield 16;
                    }
                    treeHeight = 5 + random.nextInt(2);
                    yield treeHeight + 1;
                }
                case 3 -> {
                    treeHeight = 7 + random.nextInt(4);
                    yield treeHeight + 2;
                }
                case 4 -> {
                    treeHeight = 1 + random.nextInt(2);
                    yield treeHeight + 1;
                }
                case 5 -> {
                    treeHeight = 2 + random.nextInt(6);
                    yield treeHeight + 1;
                }
                default -> {
                    treeHeight = 3 + random.nextInt(3);
                    yield treeHeight + 1;
                }
            };
            if (this.heightCheck(level, pos, extraHeight, 1)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                switch (treeType) {
                    case 0: {
                        int offset;
                        BlockPos p = pos.offset(0, -2, 0);
                        this.grow(level, p, log, 1, 0, true);
                        for (offset = -1; offset < 2; ++offset) {
                            this.grow(level, pos.offset(0, -2, 0), log, 2, offset, true);
                        }
                        this.grow(level, p, log, treeHeight + 2, true);
                        this.grow(level, pos.offset(0, -1, 0), log, 2, 1, 0, true);
                        this.grow(level, p, log, 2, 1, 1, true);
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        p = pos.offset(0, treeHeight, 0);
                        this.grow(level, p, leaves, 2, 1, 0);
                        for (offset = -1; offset < 2; ++offset) {
                            this.growLeavesWithVines(level, random, p, leaves, 0, 2, offset, 0.5f, 0.5f);
                        }
                        p = p.above();
                        this.grow(level, p, leaves, 1, 1, 1);
                        this.growTheLeaves(level, random, p, leaves, 0, 0.5f);
                        this.grow(level, random, pos, leaves, treeHeight, 1, 1, 0.5f);
                        this.grow(level, random, pos, leaves, treeHeight + 1, 2, 2, 0.5f);
                        break;
                    }
                    case 1: {
                        BlockPos p = pos.offset(0, -1, 0);
                        this.grow(level, p, log, 3, 1, true);
                        this.grow(level, p, log, 3, -1, true);
                        this.grow(level, pos.offset(0, -2, 0), log, 1, 2, 2, true);
                        this.grow(level, pos.offset(0, -treeHeight / 2, 0), log, treeHeight + treeHeight / 2, true);
                        this.grow(level, pos.offset(0, -treeHeight / 3, 0), log, 1 + treeHeight / 3, 1, 0);
                        this.grow(level, pos.offset(0, -treeHeight / 4, 0), log, treeHeight / 4, 1, 1);
                        this.grow(level, p, log, 1, 2, 0, true);
                        this.growVines(level, random, pos, 0, 3, 0, 1.0f);
                        this.growVines(level, random, pos, 0, 2, 1, 0.5f);
                        this.growVines(level, random, pos, 0, 2, -1, 0.5f);
                        int w = random.nextInt(2);
                        this.grow(level, pos.offset(0, treeHeight - 1, 0), log, 1, 0);
                        this.grow(level, pos.offset(0, treeHeight - 3, 0), log, 1, 0);
                        p = pos.offset(0, treeHeight - 4, 0);
                        this.grow(level, p, log, 2 + w, 1);
                        this.grow(level, p, log, 2 + w, -1);
                        this.growVines(level, random, p, 0, -1 - w, 1, 0.5f);
                        this.growVines(level, random, p, 0, -1 - w, -1, 0.5f);
                        p = p.below();
                        this.grow(level, p, log, 3 + w, 0);
                        this.grow(level, p, log, 3 + w, 2);
                        this.grow(level, p, log, 3 + w, -2);
                        this.growVines(level, random, p, 0, -2 - w, 0, 0.5f);
                        this.growVines(level, random, p, 0, -2 - w, 2, 0.5f);
                        this.growVines(level, random, p, 0, -2 - w, -2, 0.5f);
                        this.grow(level, p, leaves, 3 + w, 1);
                        this.grow(level, p, leaves, 3 + w, -1);
                        if (w == 1) {
                            this.grow(level, pos.offset(0, treeHeight - 3, 0), log, 2, 0);
                            this.grow(level, p, leaves, 4, 3);
                            this.grow(level, p, leaves, 4, -3);
                            p = p.above();
                            this.grow(level, p, leaves, 3, 2);
                            this.grow(level, p, leaves, 3, -2);
                            this.grow(level, p, leaves, 3, 3);
                            p = p.above();
                            this.grow(level, p, leaves, 2, 2);
                            this.grow(level, p, leaves, 2, 1);
                            this.grow(level, p, leaves, 2, -1);
                        } else {
                            this.grow(level, p.above(), leaves, 2, 2);
                        }
                        p = pos.offset(0, treeHeight - 5, 0);
                        this.grow(level, p, leaves, 3, 3);
                        this.growVines(level, random, p, 0, 4, 3 + w, 0.5f);
                        this.grow(level, pos.offset(0, treeHeight - 3, 0), leaves, 2, 1, 1);
                        p = pos.offset(0, treeHeight - 2, 0);
                        this.grow(level, p, leaves, 1, 2, 0);
                        this.setBlock((LevelWriter)level, p, leaves);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 1, 0);
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        p = pos.offset(0, treeHeight - 5, 0);
                        for (int i = -2; i < 3; i = (int)((byte)(i + 1))) {
                            this.grow(level, p, leaves, 4 + w, i);
                            this.growVines(level, random, p, 0, 5 + w, i, 0.5f);
                            this.grow(level, p.above(), leaves, 3 + w, i);
                            if (i <= -2 || i >= 2) continue;
                            this.grow(level, p.above().above(), leaves, 2 + w, i);
                        }
                        break;
                    }
                    case 2: {
                        int i;
                        int trunkY = treeHeight / 3;
                        this.grow(level, pos, log, trunkY);
                        if (treeHeight == 15) {
                            BlockPos p = pos.offset(0, trunkY + 1, 0);
                            this.grow(level, p, log, 1, 0);
                            this.grow(level, p.above(), log, 2, 1);
                            int offset = 1;
                            for (int y = trunkY + 3; y < treeHeight + 1; ++y) {
                                int width;
                                if (++offset == 2) {
                                    offset = -2;
                                    width = 2;
                                } else {
                                    width = 3;
                                }
                                this.grow(level, pos.offset(0, y, 0), log, width, offset);
                                this.grow(level, pos.offset(0, y + 1, 0), leaves, width, offset);
                                this.growLeavesWithVines(level, random, pos.offset(width, y, offset), leaves, 0, 1, 0, 1.0f, 0.5f);
                                this.growLeavesWithVines(level, random, pos.offset(-width, y, -offset), leaves, 0, 1, 0, 1.0f, 0.5f);
                                this.growLeavesWithVines(level, random, pos.offset(offset, y, -width), leaves, 0, 1, 0, 1.0f, 0.5f);
                                this.growLeavesWithVines(level, random, pos.offset(-offset, y, width), leaves, 0, 1, 0, 1.0f, 0.5f);
                            }
                            this.grow(level, p, leaves, 1);
                            this.grow(level, p, leaves, 1, 1, 1);
                            this.grow(level, p, leaves, 1, 2, 0);
                            p = p.above();
                            this.grow(level, p, leaves, 1, 0);
                            this.grow(level, p, leaves, 3, 1);
                            this.grow(level, p, leaves, 2, 2);
                            this.grow(level, pos.offset(0, extraHeight, 0), leaves, 3, offset);
                            break;
                        }
                        int length = treeHeight - trunkY;
                        int n = i = random.nextInt(4) == 0 ? 0 : 1;
                        while (i < 3) {
                            if (i == 2) {
                                treeHeight -= random.nextInt(3);
                            }
                            double stepX = (-3.0 + random.nextDouble() * 7.0) / (double)length;
                            double stepZ = (-3.0 + random.nextDouble() * 7.0) / (double)length;
                            double x = 0.0;
                            double z = 0.0;
                            for (int y = 1; y < length + 1; ++y) {
                                this.setBlock((LevelWriter)level, pos.offset((int)(x += stepX), trunkY + y, (int)(z += stepZ)), log);
                                this.grow(level, pos.offset((int)x, trunkY + y, (int)z), leaves, 1, 0);
                                this.growLeavesWithVines(level, random, pos.offset((int)x, trunkY + y, (int)z), leaves, 0, 1, 1, 0.5f, 0.3f);
                                if (y <= 1 || trunkY + y >= treeHeight) continue;
                                this.growLeavesWithVines(level, random, pos.offset((int)x, trunkY + y, (int)z), leaves, 0, 2, 0, 0.3f, 0.5f);
                            }
                            this.setBlock((LevelWriter)level, pos.offset((int)x, extraHeight, (int)z), leaves);
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        int destX = -3 + random.nextInt(7);
                        int destZ = -3 + random.nextInt(7);
                        double stepX = (double)destX / (double)(treeHeight + 1);
                        double stepZ = (double)destZ / (double)(treeHeight + 1);
                        double x = 0.0;
                        double z = 0.0;
                        for (int y = 1; y < treeHeight + 1; ++y) {
                            long pX = Math.round(x);
                            long pZ = Math.round(z);
                            this.setBlock((LevelWriter)level, pos.offset((int)pX, y, (int)pZ), log);
                            this.grow(level, pos.offset((int)pX, y, (int)pZ), log, 1, 0);
                            this.growVines(level, random, pos.offset((int)pX, y, (int)pZ), 0, 2, 0, 0.3f);
                            x += stepX;
                            z += stepZ;
                        }
                        this.grow(level, pos.offset(0, 2, 0), log, 1, 0);
                        this.grow(level, pos.offset(0, -1, 0), log, 1, true);
                        this.grow(level, pos.offset(0, 1, 0), log, 1, 1, 1);
                        this.grow(level, pos.offset(0, -2, 0), log, 3, 2, 0, true);
                        this.grow(level, pos.offset(0, -2, 0), log, 2, 2, 2, true);
                        BlockPos p = pos.offset(destX, treeHeight, destZ);
                        this.setBlock((LevelWriter)level, p, log);
                        this.setBlock((LevelWriter)level, p.offset(0, 1, 0), leaves);
                        this.grow(level, p, leaves, 1, 1, 0);
                        this.grow(level, p, log, 1, 1);
                        this.grow(level, p.above(), leaves, 1, 1);
                        for (int i = -2; i < 2; ++i) {
                            if (Math.abs(i) == 1) {
                                this.grow(level, p, log, 2, i);
                                this.grow(level, p.above(), leaves, 2, i);
                            } else {
                                this.grow(level, p, leaves, 1, 2, i);
                            }
                            this.growLeavesWithVines(level, random, p, leaves, 0, 3, i, 1.0f, 0.5f);
                            this.growLeavesWithVines(level, random, p.below(), leaves, 0, 3, i, 0.3f, 1.0f);
                        }
                        this.growLeavesWithVines(level, random, p, leaves, 0, 3, 2, 1.0f, 0.5f);
                        this.grow(level, p.offset(0, 2, 0), leaves, 1, 0);
                        this.setBlock((LevelWriter)level, p.offset(0, 2, 0), leaves);
                        break;
                    }
                    case 4: {
                        this.grow(level, pos, log, treeHeight, true);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 1, 0);
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        break;
                    }
                    case 5: {
                        this.grow(level, pos.offset(0, -3, 0), log, treeHeight - 2, 2, 0, true);
                        this.grow(level, pos.offset(0, -2, 0), log, 1, 1, 1, true);
                        this.grow(level, pos.offset(0, treeHeight - 4, 0), log, 1, 1, 0, true);
                        this.growVines(level, random, pos.offset(0, treeHeight - 4, 0), 1, 1, 1, 0.5f);
                        pos = pos.offset(0, treeHeight - 4, 0);
                    }
                    default: {
                        this.grow(level, pos, log, treeHeight);
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        this.grow(level, pos.offset(0, treeHeight - 2, 0), leaves, extraHeight + 2 - treeHeight, 1, 0);
                        this.grow(level, pos.offset(0, treeHeight - 2, 0), leaves, 1, 1, 1);
                        this.grow(level, random, pos.offset(0, treeHeight - 2, 0), leaves, 1, 2, 2, 0.5f);
                        this.growTheLeaves(level, random, pos.offset(0, treeHeight - 2, 0), leaves, 1, 0.25f);
                        this.grow(level, random, pos.offset(0, treeHeight, 0), leaves, 1, 1, 0.5f);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.growLeavesWithVines(level, random, pos.offset(0, treeHeight - 3, 0), leaves, 0, 2, offset, 0.3f, 1.0f);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

