/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.SkythernTree;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class ShiverspineTree
extends SkythernTree {
    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.is(BlockTags.SNOW) || state.is((Block)BlockRegistry.frozenGrass.get()) || state.is((Block)BlockRegistry.frozenDirt.get());
    }

    @Override
    public boolean hasSpace(BlockState state) {
        return state.is(BlockTags.SNOW) || super.hasSpace(state);
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int extraHeight;
            int treeHeight;
            if (level.getBlockState(pos.below()).is(BlockTags.SNOW)) {
                pos = pos.below();
            }
            int treeType = random.nextInt(25);
            int width = 1;
            switch (treeType) {
                case 1: 
                case 2: {
                    treeHeight = 3 + random.nextInt(6);
                    extraHeight = treeHeight + 3;
                    break;
                }
                case 0: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    width = 2;
                    treeHeight = 15 + random.nextInt(20);
                    extraHeight = treeHeight + 2;
                    break;
                }
                default: {
                    return super.place(config, level, chunkGen, random, pos);
                }
            }
            if (this.heightCheck(level, pos, extraHeight, width)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                this.grow(level, pos, log, treeHeight + 1);
                this.grow(level, pos.offset(0, treeHeight + 1, 0), leaves, extraHeight - 1 - treeHeight);
                if (width == 2) {
                    BlockPos.MutableBlockPos mut = pos.offset(1, 0, 0).mutable();
                    while (this.hasSpace(level.getBlockState((BlockPos)mut.move(0, -1, 0)))) {
                        this.setBlock(level, (BlockPos)mut, log, true);
                    }
                    this.grow(level, pos.offset(1, 0, 0), log, treeHeight + 1);
                    this.grow(level, pos.offset(1, treeHeight + 1, 0), leaves, extraHeight - 1 - treeHeight);
                    mut = pos.offset(0, 0, 1).mutable();
                    while (this.hasSpace(level.getBlockState((BlockPos)mut.move(0, -1, 0)))) {
                        this.setBlock(level, (BlockPos)mut, log, true);
                    }
                    this.grow(level, pos.offset(0, 0, 1), log, treeHeight - 1);
                    this.grow(level, pos.offset(0, treeHeight + 1, 1), leaves, extraHeight - 1 - treeHeight);
                    mut = pos.offset(1, 0, 1).mutable();
                    while (this.hasSpace(level.getBlockState((BlockPos)mut.move(0, -1, 0)))) {
                        this.setBlock(level, (BlockPos)mut, log, true);
                    }
                    this.grow(level, pos.offset(1, 0, 1), log, treeHeight + 1);
                    this.grow(level, pos.offset(1, treeHeight + 1, 1), leaves, extraHeight - 1 - treeHeight);
                }
                switch (treeType) {
                    case 1: 
                    case 2: {
                        int bottomHeight = random.nextInt(2);
                        int wideHeight = 2 - bottomHeight + random.nextInt(2);
                        boolean shift = random.nextBoolean();
                        boolean even = treeHeight % 2 == bottomHeight ^ shift;
                        for (int y = 2 - bottomHeight; y <= treeHeight; ++y) {
                            BlockPos temp;
                            if (y == wideHeight && treeType == 2 && wideHeight != extraHeight - 3) {
                                temp = pos.offset(0, y, 0);
                                this.grow(level, temp, leaves, 1, 1);
                                this.grow(level, temp, leaves, 2, -1);
                                this.grow(level, temp, leaves, 2, 0);
                                this.grow(level, temp, leaves, 2, 1);
                                this.grow(level, temp, leaves, 2, 2);
                                for (int offset = -2; offset < 3; ++offset) {
                                    this.grow(level, temp, leaves, 3, offset);
                                }
                                if (!(y % 2 == bottomHeight ^ shift)) continue;
                                shift = !shift;
                                continue;
                            }
                            if (!(y % 2 == bottomHeight ^ shift)) continue;
                            temp = pos.offset(0, y, 0);
                            this.grow(level, temp, leaves, 1, 1);
                            this.grow(level, temp, leaves, 2, -1);
                            this.grow(level, temp, leaves, 2, 0);
                            this.grow(level, temp, leaves, 2, 1);
                        }
                        this.grow(level, pos.offset(0, treeHeight, 0), log, random.nextInt(even ? 2 : 3));
                        this.grow(level, pos.offset(0, 2 - bottomHeight, 0), leaves, treeHeight + (even ? -1 : -2) + bottomHeight, 1, 0);
                        this.grow(level, pos.offset(0, extraHeight - (even ? 0 : 1), 0), leaves, 1, 0);
                        break;
                    }
                    case 7: 
                    case 8: {
                        BlockPos temp = pos.offset(0, treeHeight + 1, 0);
                        this.wideGrow(level, temp, leaves, 1, 0);
                        this.wideGrow(level, temp, leaves, 1, 1);
                        int bottomHeight = 2 + random.nextInt(5);
                        temp = pos.offset(0, bottomHeight, 0);
                        int tempInt = --treeHeight - bottomHeight;
                        this.wideGrow(level, temp, leaves, tempInt, 1, 0);
                        this.wideGrow(level, temp, leaves, tempInt, 1, 1);
                        for (width = treeHeight - 1; width > bottomHeight; --width) {
                            int offset;
                            if ((treeHeight - width) % 3 != 0) {
                                this.wideGrow(level, pos.offset(0, width, 0), leaves, 1, -1);
                                for (offset = -1; offset < 3; ++offset) {
                                    this.wideGrow(level, pos.offset(0, width, 0), leaves, 2, offset);
                                }
                            }
                            if ((treeHeight - width) % 3 != 2) continue;
                            this.wideGrow(level, pos.offset(0, width, 0), leaves, 2, -2);
                            for (offset = -2; offset < 4; ++offset) {
                                this.wideGrow(level, pos.offset(0, width, 0), leaves, 3, offset);
                            }
                        }
                        break;
                    }
                    default: {
                        BlockPos temp = pos.offset(0, extraHeight, 0);
                        this.wideGrow(level, temp, leaves, 1, 0);
                        this.wideGrow(level, temp, leaves, 1, 1);
                        int bottomHeight = 5 + random.nextInt(10);
                        ++treeHeight;
                        int stage = 2;
                        while (treeHeight > bottomHeight) {
                            for (width = 1; width < stage; ++width) {
                                extraHeight = --treeHeight + 1 - (stage - width);
                                for (int offset = 1 - width; offset <= width; ++offset) {
                                    this.wideGrow(level, pos.offset(0, extraHeight, 0), leaves, treeHeight - extraHeight, width, offset);
                                }
                                this.wideGrow(level, pos.offset(0, extraHeight, 0), leaves, treeHeight - extraHeight, width - 1, width);
                            }
                            if (stage >= 6) continue;
                            ++stage;
                        }
                        break block4;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

