/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class MortumTree
extends DivineTree {
    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.is((Block)BlockRegistry.mortumDirt.get()) || state.is((Block)BlockRegistry.mortumGrass.get());
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int extraHeight;
            int treeHeight;
            int treeType = random.nextInt(4);
            switch (treeType) {
                case 0: {
                    treeHeight = 2 + random.nextInt(4);
                    extraHeight = treeHeight + 1;
                    break;
                }
                case 1: {
                    treeHeight = 1 + random.nextInt(3);
                    extraHeight = treeHeight + 1;
                    break;
                }
                case 2: {
                    treeHeight = 0 + random.nextInt(3);
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    return super.place(config, level, (ChunkGenerator)null, random, pos);
                }
            }
            if (this.heightCheck(level, pos, extraHeight, 1)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                this.grow(level, pos, log, treeHeight);
                switch (treeType) {
                    case 0: {
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        extraHeight = 1 + random.nextInt(2);
                        BlockPos temp = pos.offset(0, extraHeight, 0);
                        this.grow(level, temp, leaves, treeHeight - extraHeight, 1, 0);
                        this.grow(level, temp.above(), leaves, treeHeight - 2 - extraHeight, 1, 1);
                        break;
                    }
                    case 1: {
                        this.setBlock(level, pos.offset(0, -1, 0), log, true);
                        this.grow(level, pos.below(), log, 1, 0, true);
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        BlockPos temp = pos.offset(0, treeHeight - 1, 0);
                        this.grow(level, temp, leaves, extraHeight + 1 - treeHeight, 1, 0);
                        this.grow(level, temp.above(), leaves, 1, 1);
                        break;
                    }
                    case 2: {
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 1, 0);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

