/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.structurelike;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.StructureRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class ArcanaDungeon
extends Feature<NoneFeatureConfiguration> {
    public static NormalNoise dungeonNoise;
    public static long seed;
    public static StructureTemplate doorway;
    public static StructureTemplate entranceRoom;
    public static StructureTemplate stairs;
    public static StructureTemplate stairsTop;
    public static StructureTemplate[] doors;
    public static Room[] adaptiveRooms;
    public static Room[] corners;
    public static Room[] junctions;
    public static Room[] crossroads;
    public static Room[] deadends;
    public static Room[] hallways;
    public static Room[] hidden;
    public static VerticalRoom[] verticalRooms;
    public static BigRoom[] bigRooms;

    public ArcanaDungeon() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place((NoneFeatureConfiguration)null, context.level(), (ChunkGenerator)null, context.random(), context.origin());
    }

    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        long newSeed;
        if (doorway == null) {
            StructureTemplateManager manager = level.getLevel().getServer().getStructureManager();
            BlockState degraded = ((Block)BlockRegistry.degradedBricks.get()).defaultBlockState();
            BlockState ancientBrick = ((Block)BlockRegistry.ancientBricks.get()).defaultBlockState();
            BlockState sludge = ((Block)BlockRegistry.soulStone.get()).defaultBlockState();
            BlockState ancient = ((Block)BlockRegistry.ancientStone.get()).defaultBlockState();
            doorway = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/doors/doorway"));
            entranceRoom = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/entrance_room"));
            stairs = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/stairs"));
            stairsTop = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/stairs_top"));
            doors = new StructureTemplate[]{manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/doors/ancient_brick")), manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/doors/degraded_brick")), manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/doors/soul_sludge")), manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/doors/soul_stone"))};
            adaptiveRooms = new Room[]{new Room(this, manager, "arcana/any/degraded_maze", degraded), new Room(this, manager, "arcana/any/heat_trap_column", ancient), new Room(this, manager, "arcana/any/hollow_column", sludge), new Room(this, manager, "arcana/any/maze", degraded), new Room(this, manager, "arcana/any/checker", degraded), new Room(this, manager, "arcana/any/pillars", ancientBrick), new Room(this, manager, "arcana/any/pillars2", degraded), new Room(this, manager, "arcana/any/razorback", ancientBrick), new Room(this, manager, "arcana/any/three_squares", ((Block)BlockRegistry.soulStone.get()).defaultBlockState()), new Room(this, manager, "arcana/any/zelus_farm", degraded), new Room(this, manager, "arcana/any/serpentine", ancientBrick)};
            crossroads = new Room[]{new Room(this, manager, "arcana/crossroads/delta_crossroads", ancientBrick), new Room(this, manager, "arcana/crossroads/extraction_crossroads", null), new Room(this, manager, "arcana/crossroads/heat_trap_crossroads", null), new Room(this, manager, "arcana/crossroads/heat_trap_crossroads_arcanium", null), new Room(this, manager, "arcana/crossroads/ramp_crossroads", ancientBrick), new Room(this, manager, "arcana/crossroads/maze_crossroads", null)};
            deadends = new Room[]{new Room(this, manager, "arcana/deadend/captain_merik_forge", ancientBrick), new Room(this, manager, "arcana/deadend/datticon_workshop", degraded), new Room(this, manager, "arcana/deadend/hill_dead_end", null), new Room(this, manager, "arcana/deadend/lava_dead_end", degraded), new Room(this, manager, "arcana/deadend/lord_vatticus_study", degraded), new Room(this, manager, "arcana/deadend/tar_dead_end_arcanium", degraded), new Room(this, manager, "arcana/deadend/war_general_chamber", ancientBrick), new Room(this, manager, "arcana/deadend/roamer_chamber", null)};
            hallways = new Room[]{new Room(this, manager, "arcana/hallway/dungeon_prison", degraded), new Room(this, manager, "arcana/hallway/dungeon_prison_broken", degraded), new Room(this, manager, "arcana/hallway/heat_trap_hallway", null), new Room(this, manager, "arcana/hallway/leorna_garden", ancientBrick), new Room(this, manager, "arcana/hallway/tar_hallway", degraded), new Room(this, manager, "arcana/hallway/utility_hallway", ancientBrick), new Room(this, manager, "arcana/hallway/v_hallway", degraded)};
            junctions = new Room[]{new Room(this, manager, "arcana/junction/degraded_junction", degraded), new Room(this, manager, "arcana/junction/heat_trap_junction", null), new Room(this, manager, "arcana/junction/metal", sludge), new Room(this, manager, "arcana/junction/mound_junction", ancient), new Room(this, manager, "arcana/junction/serpentine_junction", ancientBrick), new Room(this, manager, "arcana/junction/trident_junction", ancientBrick), new Room(this, manager, "arcana/junction/utility_room_junction", degraded), new Room(this, manager, "arcana/junction/v_junction", ancientBrick)};
            corners = new Room[]{new Room(this, manager, "arcana/corner/kazari_prison", degraded), new Room(this, manager, "arcana/corner/delta_corner", ancientBrick), new Room(this, manager, "arcana/corner/heat_trap_corner", degraded), junctions[2], new Room(this, manager, "arcana/corner/blocky_corner", degraded)};
            hidden = new Room[]{new Room(this, manager, "arcana/hidden/secret_garden", ancientBrick), new Room(this, manager, "arcana/hidden/power_core", null)};
            verticalRooms = new VerticalRoom[]{new VerticalRoom(this, manager, "arcana/vertical/ramp_hallway", ancientBrick, null), new VerticalRoom(this, manager, "arcana/vertical/any/staircase", degraded, null), new VerticalRoom(this, manager, "arcana/vertical/any/spiral_staircase", ancientBrick, null), new VerticalRoom(this, manager, "arcana/vertical/any/pyramid", ancientBrick, doors[1]), new VerticalRoom(this, manager, "arcana/vertical/living_statue_corner", null, doors[2])};
            bigRooms = new BigRoom[]{new BigRoom(this, manager, "arcana/big/library"), new BigRoom(this, manager, "arcana/big/dramix_room"), new BigRoom(this, manager, "arcana/big/parasecta_room")};
        }
        if (seed != (newSeed = level.getSeed())) {
            dungeonNoise = NormalNoise.create((RandomSource)new XoroshiroRandomSource(newSeed), (int)1, (double[])new double[]{1.5});
            seed = newSeed;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                ArcanaDungeon.setBlock(level, pos.offset(x, 32, z), ((Block)BlockRegistry.ancientStone.get()).defaultBlockState());
                ArcanaDungeon.setBlock(level, pos.offset(x, 33, z), ((Block)BlockRegistry.ancientStoneBreakable.get()).defaultBlockState());
            }
        }
        if (this.generate(level, random, pos, (byte)0)) {
            if (this.generate(level, random, pos.offset(0, 8, 0), (byte)1)) {
                if (this.generate(level, random, pos.offset(0, 16, 0), (byte)2)) {
                    this.generate(level, random, pos.offset(0, 24, 0), (byte)3);
                }
            } else {
                this.generate(level, random, pos.offset(0, 24, 0), (byte)3);
            }
        } else if (this.generate(level, random, pos.offset(0, 16, 0), (byte)2)) {
            this.generate(level, random, pos.offset(0, 24, 0), (byte)3);
        }
        return true;
    }

    public boolean generate(WorldGenLevel level, RandomSource random, BlockPos pos, byte layer) {
        int chunkX = pos.getX() / 16;
        int chunkZ = pos.getZ() / 16;
        int y = layer * 256;
        if (layer < 3) {
            if (ArcanaDungeon.wantsBigRoom(chunkX, y, chunkZ)) {
                byte doorValue = (byte)(ArcanaDungeon.getDoorValue((chunkX - (chunkX < 0 ? 1 : 0)) / 2, y, (chunkZ - (chunkZ < 0 ? 1 : 0)) / 2) % 4);
                bigRooms[doorValue == 1 ? 1 : (doorValue == 2 ? 2 : 0)].gen(level, random, pos, chunkX % 2, chunkZ % 2);
            } else {
                byte roomShape = ArcanaDungeon.getRoomShape(chunkX, y, chunkZ);
                byte doorAmount = ArcanaDungeon.getDoorAmount(chunkX, y, chunkZ);
                if (random.nextInt(16) == 0 && !ArcanaDungeon.wantsBigRoom(chunkX, y + 256, chunkZ)) {
                    this.genVertical(level, random, pos, roomShape, ArcanaDungeon.getRoomShape(chunkX, y + 256, chunkZ), doorAmount);
                } else {
                    this.genRegular(level, random, pos, roomShape, doorAmount);
                    return true;
                }
            }
            return false;
        }
        byte doorAmount = ArcanaDungeon.getDoorAmount(chunkX, y, chunkZ);
        if (doorAmount != 0 && random.nextInt(92) == 0) {
            this.genEntrance(level, random, pos, ArcanaDungeon.getRoomShape(chunkX, y, chunkZ));
        } else {
            this.genRegular(level, random, pos, ArcanaDungeon.getRoomShape(chunkX, y, chunkZ), doorAmount);
        }
        return true;
    }

    private void genEntrance(WorldGenLevel level, RandomSource random, BlockPos pos, byte roomShape) {
        StructureRegistry.placeStructure(entranceRoom, level, random, pos.offset(1, 0, 1), Rotation.NONE);
        ArcanaDungeon.genWalls(level, random, pos, ((Block)BlockRegistry.ancientBricks.get()).defaultBlockState(), roomShape, null);
        int y = 8;
        while (!level.getBlockState(pos.offset(6, y, 6)).isAir()) {
            StructureRegistry.placeStructure(stairs, level, random, pos.offset(6, y, 6), Rotation.NONE);
            y += 4;
        }
        StructureRegistry.placeStructure(stairsTop, level, random, pos.offset(5, y - 1, 5), Rotation.NONE);
    }

    private void genVertical(WorldGenLevel level, RandomSource random, BlockPos pos, byte roomShape, byte upperRoomShape, byte doorAmount) {
        if (doorAmount == 2) {
            if (ArcanaDungeon.getsNorthEntrance(roomShape)) {
                if (ArcanaDungeon.hasEastDoor(roomShape)) {
                    verticalRooms[4].gen(level, random, pos, Rotation.NONE, roomShape, upperRoomShape);
                } else if (ArcanaDungeon.getsWestEntrance(roomShape)) {
                    verticalRooms[4].gen(level, random, pos, Rotation.COUNTERCLOCKWISE_90, roomShape, upperRoomShape);
                } else {
                    verticalRooms[0].gen(level, random, pos, Rotation.NONE, roomShape, upperRoomShape);
                }
            } else if (ArcanaDungeon.hasEastDoor(roomShape)) {
                if (ArcanaDungeon.hasSouthDoor(roomShape)) {
                    verticalRooms[4].gen(level, random, pos, Rotation.CLOCKWISE_90, roomShape, upperRoomShape);
                } else {
                    verticalRooms[0].gen(level, random, pos, Rotation.CLOCKWISE_90, roomShape, upperRoomShape);
                }
            } else {
                verticalRooms[4].gen(level, random, pos, Rotation.CLOCKWISE_180, roomShape, upperRoomShape);
            }
        } else {
            verticalRooms[1 + random.nextInt(3)].gen(level, random, pos, Rotation.getRandom((RandomSource)random), roomShape, upperRoomShape);
        }
    }

    private void genRegular(WorldGenLevel level, RandomSource random, BlockPos pos, byte roomShape, byte doorAmount) {
        if (random.nextInt(6) == 0) {
            adaptiveRooms[random.nextInt(adaptiveRooms.length)].gen(level, random, pos, Rotation.getRandom((RandomSource)random), roomShape);
        } else if (doorAmount == 0) {
            hidden[random.nextInt(hidden.length)].gen(level, random, pos, Rotation.NONE, roomShape);
        } else if (doorAmount == 1) {
            deadends[random.nextInt(deadends.length)].gen(level, random, pos, ArcanaDungeon.getsNorthEntrance(roomShape) ? Rotation.NONE : (ArcanaDungeon.hasEastDoor(roomShape) ? Rotation.CLOCKWISE_90 : (ArcanaDungeon.hasSouthDoor(roomShape) ? Rotation.CLOCKWISE_180 : Rotation.COUNTERCLOCKWISE_90)), roomShape);
        } else if (doorAmount == 2) {
            if (ArcanaDungeon.getsNorthEntrance(roomShape)) {
                if (ArcanaDungeon.hasEastDoor(roomShape)) {
                    corners[random.nextInt(corners.length)].gen(level, random, pos, Rotation.NONE, roomShape);
                } else if (ArcanaDungeon.getsWestEntrance(roomShape)) {
                    corners[random.nextInt(corners.length)].gen(level, random, pos, Rotation.COUNTERCLOCKWISE_90, roomShape);
                } else {
                    hallways[random.nextInt(hallways.length)].gen(level, random, pos, Rotation.NONE, roomShape);
                }
            } else if (ArcanaDungeon.hasEastDoor(roomShape)) {
                if (ArcanaDungeon.hasSouthDoor(roomShape)) {
                    corners[random.nextInt(corners.length)].gen(level, random, pos, Rotation.CLOCKWISE_90, roomShape);
                } else {
                    hallways[random.nextInt(hallways.length)].gen(level, random, pos, Rotation.CLOCKWISE_90, roomShape);
                }
            } else {
                corners[random.nextInt(corners.length)].gen(level, random, pos, Rotation.CLOCKWISE_180, roomShape);
            }
        } else if (doorAmount == 3) {
            junctions[random.nextInt(junctions.length)].gen(level, random, pos, !ArcanaDungeon.hasSouthDoor(roomShape) ? Rotation.NONE : (!ArcanaDungeon.getsWestEntrance(roomShape) ? Rotation.CLOCKWISE_90 : (!ArcanaDungeon.getsNorthEntrance(roomShape) ? Rotation.CLOCKWISE_180 : Rotation.COUNTERCLOCKWISE_90)), roomShape);
        } else {
            crossroads[random.nextInt(crossroads.length)].gen(level, random, pos, Rotation.NONE, roomShape);
        }
    }

    public static boolean wantsBigRoom(int chunkX, int y, int chunkZ) {
        int xPart = chunkX % 2;
        int zPart = chunkZ % 2;
        return ArcanaDungeon.getDoorAmount(chunkX, y, chunkZ) == 0 || ArcanaDungeon.getDoorAmount(chunkX + 1 + (chunkX > -1 ? -2 : 2) * xPart, y, chunkZ) == 0 || ArcanaDungeon.getDoorAmount(chunkX, y, chunkZ + 1 + (chunkZ > -1 ? -2 : 2) * zPart) == 0 || ArcanaDungeon.getDoorAmount(chunkX + 1 + (chunkX > -1 ? -2 : 2) * xPart, y, chunkZ + 1 + (chunkZ > -1 ? -2 : 2) * zPart) == 0;
    }

    public static byte getRoomShape(int chunkX, int y, int chunkZ) {
        byte doorValue = ArcanaDungeon.getDoorValue(chunkX, y, chunkZ);
        byte hasXDoor = (byte)(doorValue % 2);
        byte hasZDoor = (byte)(doorValue / 2 % 2);
        byte hasXEntrance = (byte)(ArcanaDungeon.getDoorValue(chunkX - 1, y, chunkZ) % 2);
        byte hasZEntrance = (byte)(ArcanaDungeon.getDoorValue(chunkX, y, chunkZ - 1) / 2 % 2);
        return (byte)(hasXDoor + hasZDoor * 2 + hasXEntrance * 4 + hasZEntrance * 8);
    }

    public static byte getDoorAmount(int chunkX, int y, int chunkZ) {
        byte doorValue = ArcanaDungeon.getDoorValue(chunkX, y, chunkZ);
        byte hasXDoor = (byte)(doorValue % 2);
        byte hasZDoor = (byte)(doorValue / 2 % 2);
        byte hasXEntrance = (byte)(ArcanaDungeon.getDoorValue(chunkX - 1, y, chunkZ) % 2);
        byte hasZEntrance = (byte)(ArcanaDungeon.getDoorValue(chunkX, y, chunkZ - 1) / 2 % 2);
        return (byte)(hasXDoor + hasZDoor + hasXEntrance + hasZEntrance);
    }

    public static boolean getsWestEntrance(byte roomShape) {
        return roomShape / 4 % 2 == 1;
    }

    public static boolean getsNorthEntrance(byte roomShape) {
        return roomShape / 8 % 2 == 1;
    }

    public static boolean hasEastDoor(byte doorValue) {
        return doorValue % 2 == 1;
    }

    public static boolean hasEastDoor(int chunkX, int y, int chunkZ) {
        return ArcanaDungeon.getDoorValue(chunkX, y, chunkZ) % 2 == 1;
    }

    public static boolean hasSouthDoor(byte doorValue) {
        return doorValue / 2 % 2 == 1;
    }

    public static boolean hasSouthDoor(int chunkX, int y, int chunkZ) {
        return ArcanaDungeon.getDoorValue(chunkX, y, chunkZ) / 2 % 2 == 1;
    }

    public static byte getDoorValue(int chunkX, int y, int chunkZ) {
        byte value = 0;
        for (int steps = 0; value == 0 && steps < 16; steps = (int)((byte)(steps + 1))) {
            value = (byte)(Math.abs(dungeonNoise.getValue((double)(chunkX - 111 * steps), (double)(y + 112 * steps), (double)(chunkZ - 113 * steps))) * 15.7);
        }
        return value;
    }

    public static void placeRoom(StructureTemplate room, WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation, byte getsWalls) {
        boolean b = rotation == Rotation.CLOCKWISE_180;
        pos = pos.offset(b || rotation == Rotation.CLOCKWISE_90 ? 15 - getsWalls : (int)getsWalls, 0, b || rotation == Rotation.COUNTERCLOCKWISE_90 ? 15 - getsWalls : (int)getsWalls);
        room.placeInWorld((ServerLevelAccessor)level, pos, pos, StructureRegistry.defaultSettings.setRotation(rotation), random, 2);
    }

    public static void setBlock(WorldGenLevel level, BlockPos pos, BlockState block) {
        level.setBlock(pos, block, 3);
    }

    public static void genDoors(WorldGenLevel level, RandomSource random, BlockPos pos, byte roomShape, @Nullable StructureTemplate door) {
        boolean b;
        boolean bl = b = door == null;
        if (ArcanaDungeon.hasEastDoor(roomShape)) {
            StructureRegistry.placeStructure(b ? (random.nextInt(25) == 0 ? doors[random.nextInt(doors.length)] : doorway) : door, level, random, pos.offset(15, 1, 6), Rotation.CLOCKWISE_90);
        }
        if (ArcanaDungeon.hasSouthDoor(roomShape)) {
            StructureRegistry.placeStructure(b ? (random.nextInt(25) == 0 ? doors[random.nextInt(doors.length)] : doorway) : door, level, random, pos.offset(9, 1, 15), Rotation.CLOCKWISE_180);
        }
        if (ArcanaDungeon.getsWestEntrance(roomShape)) {
            StructureRegistry.placeStructure(b ? (random.nextInt(25) == 0 ? doors[random.nextInt(doors.length)] : doorway) : door, level, random, pos.offset(0, 1, 9), Rotation.COUNTERCLOCKWISE_90);
        }
        if (ArcanaDungeon.getsNorthEntrance(roomShape)) {
            StructureRegistry.placeStructure(b ? (random.nextInt(25) == 0 ? doors[random.nextInt(doors.length)] : doorway) : door, level, random, pos.offset(6, 1, 0), Rotation.NONE);
        }
    }

    public static void genWalls(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState wallBlock, byte roomShape, @Nullable StructureTemplate door) {
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 16; ++x) {
                ArcanaDungeon.setBlock(level, pos.offset(x, y, 0), wallBlock);
                ArcanaDungeon.setBlock(level, pos.offset(x, y, 15), wallBlock);
            }
            for (int z = 1; z < 15; ++z) {
                ArcanaDungeon.setBlock(level, pos.offset(0, y, z), wallBlock);
                ArcanaDungeon.setBlock(level, pos.offset(15, y, z), wallBlock);
            }
        }
        ArcanaDungeon.genDoors(level, random, pos, roomShape, door);
    }

    class Room {
        public final StructureTemplate room;
        public final BlockState wallBlock;

        public Room(ArcanaDungeon this$0, StructureTemplateManager manager, @Nullable String location, BlockState wallBlock) {
            this.room = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)location));
            this.wallBlock = wallBlock;
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation, byte roomShape) {
            boolean b;
            boolean bl = b = this.wallBlock != null;
            if (b) {
                ArcanaDungeon.genWalls(level, random, pos, this.wallBlock, roomShape, null);
            }
            ArcanaDungeon.placeRoom(this.room, level, random, pos, rotation, b ? (byte)1 : 0);
        }
    }

    class VerticalRoom {
        public final StructureTemplate room;
        public final StructureTemplate door;
        public final BlockState wallBlock;

        public VerticalRoom(ArcanaDungeon this$0, StructureTemplateManager manager, @Nullable String location, @Nullable BlockState wallBlock, StructureTemplate upperRoomDoor) {
            this.room = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)location));
            this.wallBlock = wallBlock;
            this.door = upperRoomDoor;
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation, byte roomShape, byte upperRoomShape) {
            boolean b;
            boolean bl = b = this.wallBlock != null;
            if (b) {
                ArcanaDungeon.genWalls(level, random, pos, this.wallBlock, roomShape, null);
                ArcanaDungeon.genWalls(level, random, pos.offset(0, 8, 0), this.wallBlock, upperRoomShape, this.door);
            }
            ArcanaDungeon.placeRoom(this.room, level, random, pos, rotation, b ? (byte)1 : 0);
        }
    }

    class BigRoom {
        public final StructureTemplate room;

        public BigRoom(ArcanaDungeon this$0, StructureTemplateManager manager, String room) {
            this.room = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)room));
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, int xPart, int zPart) {
            if (xPart == 0) {
                if (zPart == 0) {
                    ArcanaDungeon.placeRoom(this.room, level, random, pos, Rotation.NONE, (byte)0);
                } else {
                    ArcanaDungeon.placeRoom(this.room, level, random, pos, Rotation.COUNTERCLOCKWISE_90, (byte)0);
                }
            } else if (zPart == 0) {
                ArcanaDungeon.placeRoom(this.room, level, random, pos, Rotation.CLOCKWISE_90, (byte)0);
            } else {
                ArcanaDungeon.placeRoom(this.room, level, random, pos, Rotation.CLOCKWISE_180, (byte)0);
            }
        }
    }
}

