/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.plant;

import divinerpg.blocks.iceika.BlockBrittleGrass;
import divinerpg.registries.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BrittlePlants
extends Feature<NoneFeatureConfiguration> {
    public BrittlePlants() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place((NoneFeatureConfiguration)null, context.level(), (ChunkGenerator)null, context.random(), context.origin());
    }

    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        if (level.getBlockState(pos).is((Block)BlockRegistry.brittleMoss.get())) {
            BlockPos p = pos.above();
            if (level.getBlockState(p).isAir() && random.nextBoolean()) {
                this.setBlock((LevelWriter)level, p, random.nextBoolean() ? ((Block)BlockRegistry.winterberryBush.get()).defaultBlockState() : ((Block)BlockRegistry.brittleGrass.get()).defaultBlockState());
            } else {
                p = pos.below();
                if (level.getBlockState(p).isAir()) {
                    if (random.nextBoolean()) {
                        int length = random.nextInt(4);
                        for (int i = 0; i < length && level.getBlockState(p.below()).isAir(); ++i) {
                            this.setBlock((LevelWriter)level, p, ((Block)BlockRegistry.winterberryVinesBody.get()).defaultBlockState());
                            p = p.below();
                        }
                        this.setBlock((LevelWriter)level, p, ((Block)BlockRegistry.winterberryVinesHead.get()).defaultBlockState());
                    } else {
                        this.setBlock((LevelWriter)level, p, (BlockState)((Block)BlockRegistry.brittleGrass.get()).defaultBlockState().setValue((Property)BlockBrittleGrass.HANGING, (Comparable)Boolean.valueOf(true)));
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

