/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.registries.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WhaleSkeleton
extends Feature<NoneFeatureConfiguration> {
    public static BlockState xBone;
    public static BlockState yBone;
    public static BlockState zBone;
    public static BlockState coalstone;

    public WhaleSkeleton() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> config) {
        return this.place((NoneFeatureConfiguration)null, config.level(), (ChunkGenerator)null, config.random(), config.origin());
    }

    public boolean place(NoneFeatureConfiguration config, WorldGenLevel level, ChunkGenerator c, RandomSource random, BlockPos origin) {
        BlockState bone;
        if (xBone == null) {
            xBone = (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X);
            yBone = Blocks.BONE_BLOCK.defaultBlockState();
            zBone = (BlockState)Blocks.BONE_BLOCK.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z);
            coalstone = ((Block)BlockRegistry.coalstone.get()).defaultBlockState();
        }
        if (random.nextBoolean()) {
            origin = origin.below();
        }
        Direction direction = Direction.getRandom((RandomSource)random);
        while (direction.getAxis().isVertical()) {
            direction = Direction.getRandom((RandomSource)random);
        }
        boolean isZ = direction.getAxis() == Direction.Axis.Z;
        BlockState blockState = bone = isZ ? zBone : xBone;
        if (random.nextBoolean()) {
            byte length = random.nextBoolean() ? (byte)(random.nextInt(21) + 1) : (byte)(random.nextInt(15) + 1);
            byte shift = (byte)random.nextInt(14);
            byte ribAmount = (byte)(length % 15 / 2 - shift / 2);
            byte rib = 0;
            int ribDir = random.nextBoolean() ? 1 : -1;
            boolean flag = false;
            if (ribDir == -1 && shift < 11) {
                int i = random.nextInt(7 - shift / 3);
                origin = origin.above(i);
                boolean bl = flag = i == 6;
            }
            if (shift > length) {
                return false;
            }
            BlockPos.MutableBlockPos mut = origin.mutable();
            BlockState otherbone = isZ ? xBone : zBone;
            Direction.Axis otherAx = isZ ? Direction.Axis.X : Direction.Axis.Z;
            for (byte b = 0; b < length; b = (byte)(b + 1)) {
                if (random.nextFloat() < 0.2f && !this.isSpace(level.getBlockState((BlockPos)mut)) && this.isSpace(level.getBlockState(mut.above()))) {
                    mut.move(Direction.UP);
                } else if (random.nextFloat() < 0.4f && this.isSpace(level.getBlockState(mut.below()))) {
                    mut.move(Direction.DOWN);
                }
                this.setBlock(level, (BlockPos)mut, bone, random);
                this.setBlock(level, mut.relative(otherAx, 1), bone, random);
                byte bshift = (byte)(b + shift);
                if (rib < ribAmount && bshift % 2 == 0) {
                    for (int r = -1; r < 3; r = (int)((byte)(r + 1))) {
                        if (r != -1 && r != 2) continue;
                        BlockPos.MutableBlockPos ribmut = mut.relative(otherAx, r).mutable();
                        this.setBlock(level, (BlockPos)ribmut, otherbone, random);
                        if (bshift == 11) {
                            ribmut.move(0, ribDir, 0);
                        }
                        if (flag && bshift < 13 && bshift > 5) {
                            ribmut = ribmut.relative(otherAx, r == 2 ? 1 : -1).mutable();
                            if (bshift != 11) {
                                ribmut.move(0, -1, 0);
                            }
                            this.setBlock(level, (BlockPos)ribmut, otherbone, random);
                            ribmut = ribmut.move(0, -1, 0).relative(otherAx, r == 2 ? 1 : -1).mutable();
                            for (int d = 0; d < 4; d = (int)((byte)(d + 1))) {
                                this.setBlock(level, (BlockPos)ribmut, yBone, random);
                                ribmut.move(0, -1, 0);
                            }
                            this.setBlock(level, ribmut.relative(otherAx, r == 2 ? -1 : 1), otherbone, random);
                            continue;
                        }
                        if (bshift == 13 || !this.noBreak(random)) continue;
                        ribmut = ribmut.relative(otherAx, r == 2 ? 1 : -1).mutable();
                        if (bshift == 1) {
                            this.setBlock(level, (BlockPos)ribmut.move(0, ribDir, 0), yBone, random);
                            if (!this.noBreak(random)) continue;
                            this.setBlock(level, (BlockPos)ribmut.move(0, ribDir, 0), yBone, random);
                            if (!this.noBreak(random)) continue;
                            this.setBlock(level, ribmut.move(0, ribDir, 0).relative(otherAx, r == 2 ? -1 : 1), otherbone, random);
                            continue;
                        }
                        if (bshift != 11 && bshift != 3) {
                            ribmut.move(0, ribDir, 0);
                        }
                        this.setBlock(level, (BlockPos)ribmut, otherbone, random);
                        ribmut = ribmut.relative(otherAx, r == 2 ? 1 : -1).mutable();
                        byte size = (byte)(bshift > 5 ? 4 : 3);
                        boolean noBreak = true;
                        for (byte d = 0; noBreak && d < size; d = (byte)(d + 1)) {
                            if (this.noBreak(random)) {
                                this.setBlock(level, (BlockPos)ribmut.move(0, ribDir, 0), yBone, random);
                                continue;
                            }
                            noBreak = false;
                        }
                        if (!noBreak || !this.noBreak(random)) continue;
                        this.setBlock(level, ribmut.move(0, ribDir, 0).relative(otherAx, r == 2 ? -1 : 1), otherbone, random);
                    }
                    rib = (byte)(rib + 1);
                }
                mut.move(direction);
                if (!(random.nextFloat() < 0.2f)) continue;
                mut = mut.relative(otherAx, random.nextBoolean() ? 1 : -1).mutable();
            }
        } else if (random.nextBoolean()) {
            Direction dir = Direction.getRandom((RandomSource)random);
            while (dir == direction) {
                dir = Direction.getRandom((RandomSource)random);
            }
            BlockState otherbone = (BlockState)yBone.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis());
            if (random.nextBoolean()) {
                this.setBlock(level, origin.relative(direction, -1).relative(dir), otherbone, random);
            }
            this.setBlock(level, origin, bone, random);
            BlockPos.MutableBlockPos mut = origin.mutable();
            this.setBlock(level, (BlockPos)mut.move(direction), bone, random);
            if (random.nextBoolean()) {
                this.setBlock(level, (BlockPos)mut.move(direction), bone, random);
            }
            if (random.nextBoolean()) {
                this.setBlock(level, (BlockPos)mut.move(direction).move(dir), otherbone, random);
            }
        } else {
            if (random.nextBoolean()) {
                this.setBlock(level, origin.below(2).relative(direction), bone, random);
            }
            this.setBlock(level, origin.below(), yBone, random);
            this.setBlock(level, origin, yBone, random);
            this.setBlock(level, origin.above(), yBone, random);
            if (random.nextBoolean()) {
                this.setBlock(level, origin.above(2).relative(direction), bone, random);
            }
        }
        return true;
    }

    protected boolean noBreak(RandomSource random) {
        return random.nextFloat() < 0.8f;
    }

    protected boolean isSpace(BlockState state) {
        return state.is(Blocks.WATER) || state.isAir();
    }

    protected void setBlock(WorldGenLevel level, BlockPos pos, BlockState state, RandomSource random) {
        BlockState s = level.getBlockState(pos);
        if (s.is(Blocks.WATER) || s.isAir() || s.is(BlockTags.MOSS_REPLACEABLE) || s.is(Blocks.KELP_PLANT) || s.is(Blocks.KELP)) {
            if (random.nextFloat() < 0.09f) {
                this.setBlock((LevelWriter)level, pos, coalstone);
            } else {
                this.setBlock((LevelWriter)level, pos, state);
            }
        }
    }
}

