/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record UniversalPosition(ResourceKey<Level> dimension, Vec3 pos) {
    public UniversalPosition(Level level, Vec3 pos) {
        this((ResourceKey<Level>)level.dimension(), pos);
    }

    public UniversalPosition(ResourceKey<Level> dimension, BlockPos pos) {
        this(dimension, UniversalPosition.toVec3(pos));
    }

    public UniversalPosition(Level level, BlockPos pos) {
        this((ResourceKey<Level>)level.dimension(), UniversalPosition.toVec3(pos));
    }

    public BlockPos blockPos() {
        return new BlockPos((int)this.pos.x, (int)this.pos.y, (int)this.pos.z);
    }

    public Vec3 blockPosVec() {
        return new Vec3(Math.floor(this.pos.x), Math.floor(this.pos.y), Math.floor(this.pos.z));
    }

    public ChunkPos chunkPos() {
        return new ChunkPos((int)this.pos.x >> 4, (int)this.pos.z >> 4);
    }

    public ServerLevel level(MinecraftServer server) {
        return server.getLevel(this.dimension);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Vec3 dimension1;
        Vec3 vec3;
        if (o == null) return false;
        if (o == this) return true;
        if (!(o instanceof UniversalPosition)) return false;
        UniversalPosition universalPosition = (UniversalPosition)o;
        try {
            dimension1 = vec3 = universalPosition.dimension();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Vec3 pos1 = vec3 = universalPosition.pos();
        if (dimension1 != this.dimension) return false;
        if (!pos1.equals((Object)this.pos)) return false;
        return true;
    }

    public static BlockPos toBlockPos(Vec3 v) {
        return new BlockPos((int)v.x, (int)v.y, (int)v.z);
    }

    public static Vec3 toVec3(BlockPos p) {
        return new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ());
    }

    @Override
    public String toString() {
        return String.valueOf(this.dimension.location()) + ", " + String.valueOf(this.pos);
    }
}

