/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import divinerpg.DivineRPG;
import divinerpg.items.arcana.ItemMeriksMissile;
import divinerpg.items.ranged.ItemBow;
import divinerpg.registries.ItemRegistry;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelPropRegistry {
    public static void init() {
        DivineRPG.LOGGER.info("[DivineRPG] Attached model properties");
        ModelPropRegistry.registerBow((ItemBow)((Object)ItemRegistry.apalachia_bow.get()), (ItemBow)((Object)ItemRegistry.soulfire_bow.get()), (ItemBow)((Object)ItemRegistry.eden_bow.get()), (ItemBow)((Object)ItemRegistry.ender_bow.get()), (ItemBow)((Object)ItemRegistry.halite_bow.get()), (ItemBow)((Object)ItemRegistry.hunter_bow.get()), (ItemBow)((Object)ItemRegistry.icicle_bow.get()), (ItemBow)((Object)ItemRegistry.inferno_bow.get()), (ItemBow)((Object)ItemRegistry.mortum_bow.get()), (ItemBow)((Object)ItemRegistry.shadow_bow.get()), (ItemBow)((Object)ItemRegistry.skythern_bow.get()), (ItemBow)((Object)ItemRegistry.snowstorm_bow.get()), (ItemBow)((Object)ItemRegistry.twilight_bow.get()), (ItemBow)((Object)ItemRegistry.wildwood_bow.get()), (ItemBow)((Object)ItemRegistry.amthirmis_bow.get()), (ItemBow)((Object)ItemRegistry.arksiane_bow.get()), (ItemBow)((Object)ItemRegistry.cermile_bow.get()), (ItemBow)((Object)ItemRegistry.darven_bow.get()), (ItemBow)((Object)ItemRegistry.everfright.get()), (ItemBow)((Object)ItemRegistry.heliosis_bow.get()), (ItemBow)((Object)ItemRegistry.karos_bow.get()), (ItemBow)((Object)ItemRegistry.pardimal_bow.get()), (ItemBow)((Object)ItemRegistry.quadrotic_bow.get()), (ItemBow)((Object)ItemRegistry.teaker_bow.get()));
        ModelPropRegistry.registerMerik((ItemMeriksMissile)((Object)ItemRegistry.meriks_missile.get()));
        ModelPropRegistry.registerShield(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"blocking"), (stack, world, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f, (Item)ItemRegistry.realmite_shield.get(), (Item)ItemRegistry.arlemite_shield.get(), (Item)ItemRegistry.rupee_shield.get(), (Item)ItemRegistry.eden_shield.get(), (Item)ItemRegistry.wildwood_shield.get(), (Item)ItemRegistry.apalachia_shield.get(), (Item)ItemRegistry.skythern_shield.get(), (Item)ItemRegistry.mortum_shield.get(), (Item)ItemRegistry.halite_shield.get());
    }

    public static void registerBow(ItemBow ... item) {
        for (ItemBow bow : item) {
            ItemProperties.register((Item)bow, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, entity, i) -> {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
            });
            ItemProperties.register((Item)bow, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        }
    }

    public static void registerMerik(ItemMeriksMissile ... item) {
        for (ItemMeriksMissile missile : item) {
            ItemProperties.register((Item)missile, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, entity, i) -> {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
            });
            ItemProperties.register((Item)missile, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        }
    }

    private static void registerShield(ResourceLocation override, ItemPropertyFunction propertyGetter, Item ... shields) {
        for (Item shield : shields) {
            ItemProperties.register((Item)shield.asItem(), (ResourceLocation)override, (ItemPropertyFunction)propertyGetter);
        }
    }
}

