/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ArmorMaterialRegistry {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"divinerpg");
    public static final Holder<ArmorMaterial> REALMITE = ArmorMaterialRegistry.register("realmite", 2, 6, 6, 2, 0.0f, 0.0f, 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, ItemRegistry.realmite_ingot);
    public static final Holder<ArmorMaterial> SENG_FUR = ArmorMaterialRegistry.register("seng_fur", 2, 7, 6, 2, 0.0f, 0.0f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, ItemRegistry.seng_fur);
    public static final Holder<ArmorMaterial> SANTA = ArmorMaterialRegistry.register("santa", 2, 7, 6, 2, 0.0f, 0.0f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, ItemRegistry.seng_fur);
    public static final Holder<ArmorMaterial> AQUASTRIVE = ArmorMaterialRegistry.register("aquastrive", 2, 7, 6, 2, 0.0f, 0.0f, 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, ItemRegistry.aquatic_ingot);
    public static final Holder<ArmorMaterial> KRAKEN = ArmorMaterialRegistry.register("kraken", 2, 7, 6, 3, 0.0f, 0.0f, 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_TURTLE, ItemRegistry.kraken_skin);
    public static final Holder<ArmorMaterial> JACK_O_MAN = ArmorMaterialRegistry.register("jack_o_man", 2, 7, 6, 3, 0.0f, 0.0f, 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GENERIC, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN}));
    public static final Holder<ArmorMaterial> SKELEMAN = ArmorMaterialRegistry.register("skeleman", 2, 7, 6, 3, 0.0f, 0.0f, 9, (Holder<SoundEvent>)Holder.direct((Object)SoundEvents.SKELETON_STEP), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}));
    public static final Holder<ArmorMaterial> WITHER_REAPER = ArmorMaterialRegistry.register("wither_reaper", 2, 7, 6, 3, 0.0f, 0.0f, 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}));
    public static final Holder<ArmorMaterial> ARLEMITE = ArmorMaterialRegistry.register("arlemite", 3, 7, 6, 3, 1.5f, 0.0f, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, ItemRegistry.arlemite_ingot);
    public static final Holder<ArmorMaterial> FROZEN = ArmorMaterialRegistry.register("frozen", 3, 8, 6, 3, 2.0f, 0.0f, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.ice_stone);
    public static final Holder<ArmorMaterial> JUNGLE = ArmorMaterialRegistry.register("jungle", 3, 8, 6, 3, 2.0f, 0.0f, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.jungle_stone);
    public static final Holder<ArmorMaterial> INFERNO = ArmorMaterialRegistry.register("inferno", 3, 8, 6, 3, 2.0f, 0.0f, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.molten_stone);
    public static final Holder<ArmorMaterial> TORRIDITE = ArmorMaterialRegistry.register("torridite", 3, 8, 6, 3, 2.0f, 0.0f, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, ItemRegistry.torridite_chunk);
    public static final Holder<ArmorMaterial> TERRAN = ArmorMaterialRegistry.register("terran", 3, 8, 6, 3, 2.0f, 0.0f, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.terran_stone);
    public static final Holder<ArmorMaterial> ANGELIC = ArmorMaterialRegistry.register("angelic", 3, 8, 6, 3, 2.0f, 0.0f, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.shadow_stone);
    public static final Holder<ArmorMaterial> SHADOW = ArmorMaterialRegistry.register("shadow", 3, 8, 6, 3, 2.0f, 0.0f, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.shadow_stone);
    public static final Holder<ArmorMaterial> RUPEE = ArmorMaterialRegistry.register("rupee", 3, 8, 6, 3, 2.0f, 0.02f, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, ItemRegistry.rupee_ingot);
    public static final Holder<ArmorMaterial> RED_RUPEE = ArmorMaterialRegistry.register("red_rupee", 3, 8, 6, 3, 2.0f, 0.02f, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, ItemRegistry.rupee_ingot);
    public static final Holder<ArmorMaterial> YELLOW_RUPEE = ArmorMaterialRegistry.register("yellow_rupee", 3, 8, 6, 3, 2.0f, 0.02f, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, ItemRegistry.rupee_ingot);
    public static final Holder<ArmorMaterial> GREEN_RUPEE = ArmorMaterialRegistry.register("green_rupee", 3, 8, 6, 3, 2.0f, 0.02f, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, ItemRegistry.rupee_ingot);
    public static final Holder<ArmorMaterial> BLUE_RUPEE = ArmorMaterialRegistry.register("blue_rupee", 3, 8, 6, 3, 2.0f, 0.02f, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, ItemRegistry.rupee_ingot);
    public static final Holder<ArmorMaterial> GRAY_RUPEE = ArmorMaterialRegistry.register("gray_rupee", 3, 8, 6, 3, 2.0f, 0.02f, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, ItemRegistry.rupee_ingot);
    public static final Holder<ArmorMaterial> ELITE_REALMITE = ArmorMaterialRegistry.register("elite_realmite", 3, 9, 7, 3, 3.0f, 0.1f, 16, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.realmiteBlock.asItem()}));
    public static final Holder<ArmorMaterial> CORRUPTED = ArmorMaterialRegistry.register("corrupted", 3, 9, 7, 3, 3.0f, 0.05f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.corrupted_stone);
    public static final Holder<ArmorMaterial> BEDROCK = ArmorMaterialRegistry.register("bedrock", 4, 9, 7, 3, 3.0f, 0.12f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE);
    public static final Holder<ArmorMaterial> KORMA = ArmorMaterialRegistry.register("korma", 4, 9, 7, 3, 3.0f, 0.12f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, ItemRegistry.arcanium);
    public static final Holder<ArmorMaterial> VEMOS = ArmorMaterialRegistry.register("vemos", 4, 9, 7, 3, 3.0f, 0.12f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, ItemRegistry.arcanium);
    public static final Holder<ArmorMaterial> ENDER = ArmorMaterialRegistry.register("ender", 4, 7, 9, 3, 3.0f, 0.12f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND);
    public static final Holder<ArmorMaterial> RED_ENDER = ArmorMaterialRegistry.register("red_ender", 4, 7, 9, 3, 3.0f, 0.12f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND);
    public static final Holder<ArmorMaterial> YELLOW_ENDER = ArmorMaterialRegistry.register("yellow_ender", 4, 7, 9, 3, 3.0f, 0.12f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND);
    public static final Holder<ArmorMaterial> GREEN_ENDER = ArmorMaterialRegistry.register("green_ender", 4, 7, 9, 3, 3.0f, 0.12f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND);
    public static final Holder<ArmorMaterial> BLUE_ENDER = ArmorMaterialRegistry.register("blue_ender", 4, 7, 9, 3, 3.0f, 0.12f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND);
    public static final Holder<ArmorMaterial> GRAY_ENDER = ArmorMaterialRegistry.register("gray_ender", 4, 7, 9, 3, 3.0f, 0.12f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND);
    public static final Holder<ArmorMaterial> DIVINE = ArmorMaterialRegistry.register("divine", 4, 9, 7, 4, 3.0f, 0.13f, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND);
    public static final Holder<ArmorMaterial> EDEN = ArmorMaterialRegistry.register("eden", 4, 9, 8, 4, 3.0f, 0.14f, 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, ItemRegistry.eden_gem);
    public static final Holder<ArmorMaterial> WILDWOOD = ArmorMaterialRegistry.register("wildwood", 5, 9, 8, 4, 3.5f, 0.15f, 21, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.wildwood_gem);
    public static final Holder<ArmorMaterial> APALACHIA = ArmorMaterialRegistry.register("apalachia", 5, 9, 8, 5, 3.5f, 0.16f, 22, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.apalachia_gem);
    public static final Holder<ArmorMaterial> SKYTHERN = ArmorMaterialRegistry.register("skythern", 5, 9, 8, 5, 4.0f, 0.18f, 23, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.skythern_gem);
    public static final Holder<ArmorMaterial> MORTUM = ArmorMaterialRegistry.register("mortum", 5, 10, 8, 5, 4.0f, 0.19f, 24, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.mortum_gem);
    public static final Holder<ArmorMaterial> HALITE = ArmorMaterialRegistry.register("halite", 5, 10, 8, 5, 4.5f, 0.2f, 25, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.mortum_gem);
    public static final Holder<ArmorMaterial> AWAKENED_HALITE = ArmorMaterialRegistry.register("awakened_halite", 5, 10, 9, 5, 4.5f, 0.21f, 26, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, ItemRegistry.arcanium);
    public static final Holder<ArmorMaterial> DEGRADED = ArmorMaterialRegistry.register("degraded", 3, 5, 4, 2, 2.0f, 0.0f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final Holder<ArmorMaterial> FINISHED = ArmorMaterialRegistry.register("finished", 3, 6, 5, 3, 3.0f, 0.0f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final Holder<ArmorMaterial> GLISTENING = ArmorMaterialRegistry.register("glistening", 4, 7, 6, 3, 4.0f, 0.0f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final Holder<ArmorMaterial> DEMONIZED = ArmorMaterialRegistry.register("demonized", 4, 7, 6, 3, 5.0f, 0.0f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);
    public static final Holder<ArmorMaterial> TORMENTED = ArmorMaterialRegistry.register("tormented", 4, 7, 6, 3, 6.0f, 0.0f, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON);

    private static Holder<ArmorMaterial> register(String name, int helmetArmor, int chestplateArmor, int leggingsArmor, int bootsArmor, float toughness, float knockbackResistance, Holder<SoundEvent> equipSound) {
        return ArmorMaterialRegistry.register(name, helmetArmor, chestplateArmor, leggingsArmor, bootsArmor, toughness, knockbackResistance, 0, equipSound, () -> Ingredient.EMPTY);
    }

    private static Holder<ArmorMaterial> register(String name, int helmetArmor, int chestplateArmor, int leggingsArmor, int bootsArmor, float toughness, float knockbackResistance, int enchantability, Holder<SoundEvent> equipSound) {
        return ArmorMaterialRegistry.register(name, helmetArmor, chestplateArmor, leggingsArmor, bootsArmor, toughness, knockbackResistance, enchantability, equipSound, () -> Ingredient.EMPTY);
    }

    private static Holder<ArmorMaterial> register(String name, int helmetArmor, int chestplateArmor, int leggingsArmor, int bootsArmor, float toughness, float knockbackResistance, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> ing) {
        EnumMap<ArmorItem.Type, Integer> enummap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        enummap.put(ArmorItem.Type.HELMET, helmetArmor);
        enummap.put(ArmorItem.Type.CHESTPLATE, chestplateArmor);
        enummap.put(ArmorItem.Type.LEGGINGS, leggingsArmor);
        enummap.put(ArmorItem.Type.BOOTS, bootsArmor);
        return ARMOR_MATERIALS.register(name, () -> new ArmorMaterial((Map)enummap, enchantability, equipSound, ing, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)name))), toughness, knockbackResistance));
    }

    private static Holder<ArmorMaterial> register(String name, int helmetArmor, int chestplateArmor, int leggingsArmor, int bootsArmor, float toughness, float knockbackResistance, int enchantability, Holder<SoundEvent> equipSound, DeferredItem<Item> repair) {
        return ArmorMaterialRegistry.register(name, helmetArmor, chestplateArmor, leggingsArmor, bootsArmor, toughness, knockbackResistance, enchantability, equipSound, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)repair.get()}));
    }
}

