/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.registries.RecipeRegistry;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public record MaulSmashingRecipe(Ingredient input, ItemStack output, @Nullable TagKey<Block> requiredBaseBlockTag) implements Recipe<RecipeInput>
{
    public static final RecipeType<MaulSmashingRecipe> TYPE = RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"maul_smashing"));

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    public ItemStack getResult() {
        return this.output.copy();
    }

    public boolean matches(RecipeInput container, Level level) {
        return this.input.test(container.getItem(0));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.Serailizers.MAUL_SMASHING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.Types.MAUL_SMASHING.get();
    }

    public static class Serializer
    implements RecipeSerializer<MaulSmashingRecipe> {
        private static final MapCodec<MaulSmashingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(MaulSmashingRecipe::input), (App)ItemStack.CODEC.fieldOf("output").forGetter(MaulSmashingRecipe::output), (App)TagKey.hashedCodec((ResourceKey)Registries.BLOCK).optionalFieldOf("required_base_block").forGetter(r -> Optional.ofNullable(r.requiredBaseBlockTag()))).apply((Applicative)instance, (input, output, baseOpt) -> new MaulSmashingRecipe((Ingredient)input, (ItemStack)output, (TagKey<Block>)((TagKey)baseOpt.orElse(null)))));
        public static final StreamCodec<RegistryFriendlyByteBuf, MaulSmashingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static void toNetwork(RegistryFriendlyByteBuf buffer, MaulSmashingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            if (recipe.requiredBaseBlockTag != null) {
                buffer.writeBoolean(true);
                buffer.writeResourceLocation(recipe.requiredBaseBlockTag.location());
            } else {
                buffer.writeBoolean(false);
            }
        }

        @Nullable
        public static MaulSmashingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            TagKey tag = null;
            if (buffer.readBoolean()) {
                ResourceLocation tagId = buffer.readResourceLocation();
                tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagId);
            }
            return new MaulSmashingRecipe(input, output, tag);
        }

        public MapCodec<MaulSmashingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MaulSmashingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

