/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.registries.RecipeRegistry;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public record FireConversionRecipe(Ingredient inputItem, RuleTest inputState, Optional<ItemStack> outputItem, Optional<BlockStateProvider> outputState, Optional<ResourceLocation> advancement, Optional<String> advancementCriteria) implements Recipe<RecipeInput>
{
    public static final MapCodec<FireConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input_item").forGetter(FireConversionRecipe::inputItem), (App)RuleTest.CODEC.fieldOf("input_state").forGetter(FireConversionRecipe::inputState), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("output_item").forGetter(FireConversionRecipe::outputItem), (App)BlockStateProvider.CODEC.optionalFieldOf("output_state").forGetter(FireConversionRecipe::outputState), (App)ResourceLocation.CODEC.optionalFieldOf("advancement").forGetter(FireConversionRecipe::advancement), (App)Codec.STRING.optionalFieldOf("advancement_criteria").forGetter(FireConversionRecipe::advancementCriteria)).apply((Applicative)instance, FireConversionRecipe::new));
    public static final RecipeType<FireConversionRecipe> TYPE = RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"maul_smashing"));

    public boolean matches(RecipeInput recipeInput, Level level) {
        return this.inputItem.test(recipeInput.getItem(0));
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.outputItem.orElse(ItemStack.EMPTY).copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.outputItem.orElse(ItemStack.EMPTY).copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.Serailizers.FIRE_CONVERSION_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.Types.FIRE_CONVERSION.get();
    }

    public static class Serializer
    implements RecipeSerializer<FireConversionRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, FireConversionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static FireConversionRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient inputItem = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            RuleTest inputState = (RuleTest)buffer.readJsonWithCodec(RuleTest.CODEC);
            ItemStack outputItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            Optional<BlockStateProvider> outputState = buffer.readBoolean() ? Optional.of((BlockStateProvider)buffer.readJsonWithCodec(BlockStateProvider.CODEC)) : Optional.empty();
            Optional<ResourceLocation> advancement = buffer.readBoolean() ? Optional.of(buffer.readResourceLocation()) : Optional.empty();
            Optional<String> advancementCriteria = buffer.readBoolean() ? Optional.of(buffer.readUtf()) : Optional.empty();
            return new FireConversionRecipe(inputItem, inputState, Optional.of(outputItem), outputState, advancement, advancementCriteria);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, FireConversionRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.inputItem);
            buffer.writeJsonWithCodec(RuleTest.CODEC, (Object)recipe.inputState);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputItem.orElse(ItemStack.EMPTY));
            if (recipe.outputState.isPresent()) {
                buffer.writeBoolean(true);
                buffer.writeJsonWithCodec(BlockStateProvider.CODEC, (Object)recipe.outputState.get());
            } else {
                buffer.writeBoolean(false);
            }
            if (recipe.advancement.isPresent()) {
                buffer.writeBoolean(true);
                buffer.writeResourceLocation(recipe.advancement.get());
            } else {
                buffer.writeBoolean(false);
            }
            if (recipe.advancementCriteria.isPresent()) {
                buffer.writeBoolean(true);
                buffer.writeUtf(recipe.advancementCriteria.get());
            } else {
                buffer.writeBoolean(false);
            }
        }

        public MapCodec<FireConversionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FireConversionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

