/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vethea;

import divinerpg.items.ranged.ItemBow;
import divinerpg.registries.SoundRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class VetheanBow
extends ItemBow {
    public VetheanBow(Item.Properties properties, int uses, int useDuration, float speedScale, Supplier<Item> infinityArrow, Integer nameColor) {
        super(properties, uses, useDuration, speedScale, infinityArrow, nameColor);
    }

    @Override
    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            ItemStack itemstack = player.getProjectile(stack);
            if (this.infinityArrow != null && (itemstack.isEmpty() || itemstack.is((Item)this.infinityArrow.get()))) {
                itemstack = new ItemStack((ItemLike)this.infinityArrow.get());
            }
            if (itemstack.isEmpty()) {
                return;
            }
            int i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)(this.getUseDuration(stack, entityLiving) - timeLeft), (boolean)true);
            if (i < 0) {
                return;
            }
            float f = VetheanBow.getPowerForTime((int)i);
            if (f >= 0.1f) {
                List list = VetheanBow.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 3.0f * this.speedScale, 1.0f, f == 1.0f, null);
                    }
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundRegistry.VETHEA_BOW, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }
}

