/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vethea;

import divinerpg.items.vethea.ItemVethean;
import divinerpg.registries.BlockRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemDreamFlint
extends ItemVethean {
    public ItemDreamFlint() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos.MutableBlockPos pos = context.getClickedPos().mutable();
        Block mortumBlock = (Block)BlockRegistry.mortumBlock.get();
        if (world.getBlockState((BlockPos)pos).is(mortumBlock)) {
            boolean northSouth = world.getBlockState(pos.above().north()).is(mortumBlock);
            if (!northSouth && !world.getBlockState(pos.above().east()).is(mortumBlock)) {
                return InteractionResult.FAIL;
            }
            while (pos.getY() < world.getMaxBuildHeight() && world.getBlockState((BlockPos)pos.move(Direction.UP)).isAir()) {
                int i;
                BlockPos.MutableBlockPos search = pos.mutable();
                if (northSouth) {
                    i = 0;
                    while (!world.getBlockState((BlockPos)search.move(Direction.NORTH)).is(mortumBlock)) {
                        if (i > 1) {
                            return InteractionResult.FAIL;
                        }
                        ++i;
                    }
                    search = pos.mutable();
                    i = 0;
                    while (!world.getBlockState((BlockPos)search.move(Direction.SOUTH)).is(mortumBlock)) {
                        if (i > 1) {
                            return InteractionResult.FAIL;
                        }
                        ++i;
                    }
                    continue;
                }
                i = 0;
                while (!world.getBlockState((BlockPos)search.move(Direction.EAST)).is(mortumBlock)) {
                    if (i > 1) {
                        return InteractionResult.FAIL;
                    }
                    ++i;
                }
                search = pos.mutable();
                i = 0;
                while (!world.getBlockState((BlockPos)search.move(Direction.WEST)).is(mortumBlock)) {
                    if (i > 1) {
                        return InteractionResult.FAIL;
                    }
                    ++i;
                }
            }
            if (world.getBlockState((BlockPos)pos).is(mortumBlock)) {
                BlockState portal = (BlockState)((Block)BlockRegistry.vetheaPortal.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)(northSouth ? Direction.Axis.Z : Direction.Axis.X));
                while (world.getBlockState((BlockPos)pos.move(Direction.DOWN)).isAir()) {
                    world.setBlock((BlockPos)pos, portal, 2);
                    BlockPos.MutableBlockPos place = pos.mutable();
                    if (northSouth) {
                        while (world.getBlockState((BlockPos)place.move(Direction.NORTH)).isAir()) {
                            world.setBlock((BlockPos)place, portal, 2);
                        }
                        place = pos.mutable();
                        while (world.getBlockState((BlockPos)place.move(Direction.SOUTH)).isAir()) {
                            world.setBlock((BlockPos)place, portal, 2);
                        }
                        continue;
                    }
                    while (world.getBlockState((BlockPos)place.move(Direction.EAST)).isAir()) {
                        world.setBlock((BlockPos)place, portal, 2);
                    }
                    place = pos.mutable();
                    while (world.getBlockState((BlockPos)place.move(Direction.WEST)).isAir()) {
                        world.setBlock((BlockPos)place, portal, 2);
                    }
                }
                Player player = context.getPlayer();
                player.getCooldowns().addCooldown(context.getItemInHand().getItem(), 40);
                context.getItemInHand().consume(1, (LivingEntity)player);
                player.playSound(SoundEvents.FLINTANDSTEEL_USE, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("dream_flint", new Object[0]));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

